/*
 * Decompiled with CFR 0.152.
 */
package me.chrr.camerapture.picture;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import me.chrr.camerapture.Camerapture;
import me.chrr.camerapture.picture.StoredPicture;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class ServerPictureStore {
    private static final int CACHE_SIZE = 250;
    private static final ServerPictureStore INSTANCE = new ServerPictureStore();
    private final Set<UUID> reservedIds = new HashSet<UUID>();
    private final Map<UUID, StoredPicture> pictureCache = new LinkedHashMap<UUID, StoredPicture>(250, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<UUID, StoredPicture> eldest) {
            return this.size() > 250;
        }
    };

    private ServerPictureStore() {
    }

    public UUID reserveId() {
        UUID id = UUID.randomUUID();
        this.reservedIds.add(id);
        return id;
    }

    public boolean unreserveId(UUID id) {
        return this.reservedIds.remove(id);
    }

    public boolean isReserved(UUID id) {
        return this.reservedIds.contains(id);
    }

    public void put(MinecraftServer server, UUID id, StoredPicture picture) throws IOException {
        if (!this.unreserveId(id)) {
            throw new IOException("UUID not reserved");
        }
        int maxImageBytes = Camerapture.CONFIG_MANAGER.getConfig().server.maxImageBytes;
        if (picture.bytes().length > maxImageBytes) {
            throw new IOException("image larger than " + maxImageBytes + " bytes");
        }
        this.pictureCache.put(id, picture);
        Path path = this.getFilePath(server, id);
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        Files.write(path, picture.bytes(), new OpenOption[0]);
    }

    @Nullable
    public StoredPicture get(MinecraftServer server, UUID id) throws IOException {
        if (this.pictureCache.containsKey(id)) {
            return this.pictureCache.get(id);
        }
        Path path = this.getFilePath(server, id);
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        StoredPicture picture = new StoredPicture(Files.readAllBytes(path));
        this.pictureCache.put(id, picture);
        return picture;
    }

    private Path getFilePath(MinecraftServer server, UUID uuid) {
        Path dataFolder = server.method_27050(class_5218.field_24188).resolve("camerapture");
        return dataFolder.resolve(String.valueOf(uuid) + ".webp");
    }

    public static ServerPictureStore getInstance() {
        return INSTANCE;
    }
}

