/*
 * Decompiled with CFR 0.152.
 */
package net.wimods.zoom.test;

import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1074;
import net.minecraft.class_1157;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_276;
import net.minecraft.class_310;
import net.minecraft.class_318;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_353;
import net.minecraft.class_3928;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_433;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_459;
import net.minecraft.class_490;
import net.minecraft.class_5498;
import net.minecraft.class_5676;
import net.minecraft.class_634;
import net.minecraft.class_6599;

public final class WiModsTestHelper
extends Enum<WiModsTestHelper> {
    private static final AtomicInteger screenshotCounter;
    private static final /* synthetic */ WiModsTestHelper[] $VALUES;

    public static WiModsTestHelper[] values() {
        return (WiModsTestHelper[])$VALUES.clone();
    }

    public static WiModsTestHelper valueOf(String name) {
        return Enum.valueOf(WiModsTestHelper.class, name);
    }

    public static void submitAndWait(Consumer<class_310> consumer) {
        class_310 mc = class_310.method_1551();
        mc.method_20493(() -> consumer.accept(mc)).join();
    }

    public static <T> T submitAndGet(Function<class_310, T> function) {
        class_310 mc = class_310.method_1551();
        return mc.method_5385(() -> function.apply(mc)).join();
    }

    public static void waitFor(Duration duration) {
        try {
            Thread.sleep(duration.toMillis());
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public static void waitUntil(String event, Predicate<class_310> condition, Duration maxDuration) {
        LocalDateTime startTime = LocalDateTime.now();
        LocalDateTime timeout = startTime.plus(maxDuration);
        System.out.println("Waiting until " + event);
        while (true) {
            if (WiModsTestHelper.submitAndGet(condition::test).booleanValue()) break;
            if (LocalDateTime.now().isAfter(timeout)) {
                throw new RuntimeException("Waiting until " + event + " took too long");
            }
            WiModsTestHelper.waitFor(Duration.ofMillis(50L));
        }
        double seconds = (double)Duration.between(startTime, LocalDateTime.now()).toMillis() / 1000.0;
        System.out.println("Waiting until " + event + " took " + seconds + "s");
    }

    public static void waitUntil(String event, Predicate<class_310> condition) {
        WiModsTestHelper.waitUntil(event, condition, Duration.ofSeconds(10L));
    }

    public static void waitForScreen(Class<? extends class_437> screenClass) {
        WiModsTestHelper.waitUntil("screen " + screenClass.getName() + " is open", mc -> screenClass.isInstance(mc.field_1755));
    }

    public static void waitForTitleScreenFade() {
        WiModsTestHelper.waitUntil("title screen fade is complete", mc -> {
            class_437 patt0$temp = mc.field_1755;
            if (!(patt0$temp instanceof class_442)) {
                return false;
            }
            class_442 titleScreen = (class_442)patt0$temp;
            return !titleScreen.field_18222;
        });
    }

    public static void waitForResourceLoading() {
        WiModsTestHelper.waitUntil("loading is complete", mc -> mc.method_18506() == null, Duration.ofMinutes(5L));
    }

    public static void waitForWorldLoad() {
        WiModsTestHelper.waitUntil("world is loaded", mc -> mc.field_1687 != null && !(mc.field_1755 instanceof class_3928), Duration.ofMinutes(30L));
    }

    public static void waitForWorldTicks(int ticks) {
        long startTicks = WiModsTestHelper.submitAndGet(mc -> mc.field_1687.method_8510());
        WiModsTestHelper.waitUntil(ticks + " world ticks have passed", mc -> mc.field_1687.method_8510() >= startTicks + (long)ticks, Duration.ofMillis(ticks * 100).plusMinutes(5L));
    }

    public static void waitForBlock(int relX, int relY, int relZ, class_2248 block) {
        class_2338 pos = WiModsTestHelper.submitAndGet(mc -> mc.field_1724.method_24515().method_10069(relX, relY, relZ));
        WiModsTestHelper.waitUntil("block at ~" + relX + " ~" + relY + " ~" + relZ + " (" + pos.method_23854() + ") is " + String.valueOf(block), mc -> mc.field_1687.method_8320(pos).method_26204() == block);
    }

    public static void takeScreenshot(String name) {
        WiModsTestHelper.takeScreenshot(name, Duration.ofMillis(50L));
    }

    public static void takeScreenshot(String name, Duration delay) {
        WiModsTestHelper.waitFor(delay);
        String count = String.format("%02d", screenshotCounter.incrementAndGet());
        String filename = count + "_" + name + ".png";
        File gameDir = FabricLoader.getInstance().getGameDir().toFile();
        WiModsTestHelper.submitAndWait(mc -> class_318.method_22690((File)gameDir, (String)filename, (class_276)mc.method_1522(), message -> {}));
    }

    public static class_4185 findButton(class_310 mc, String translationKey) {
        String message = class_1074.method_4662((String)translationKey, (Object[])new Object[0]);
        for (class_4068 drawable : mc.field_1755.field_33816) {
            class_4185 button;
            if (!(drawable instanceof class_4185) || !(button = (class_4185)drawable).method_25369().getString().equals(message)) continue;
            return button;
        }
        throw new RuntimeException(message + " button could not be found");
    }

    public static void checkButtonPosition(class_4185 button, int expectedX, int expectedY) {
        String buttonName = button.method_25369().getString();
        if (button.method_46426() != expectedX) {
            throw new RuntimeException(buttonName + " button is at the wrong X coordinate. Expected X: " + expectedX + ", actual X: " + button.method_46426());
        }
        if (button.method_46427() != expectedY) {
            throw new RuntimeException(buttonName + " button is at the wrong Y coordinate. Expected Y: " + expectedY + ", actual Y: " + button.method_46427());
        }
    }

    public static void clickButton(String translationKey) {
        String buttonText = class_1074.method_4662((String)translationKey, (Object[])new Object[0]);
        WiModsTestHelper.waitUntil("button saying " + buttonText + " is visible", mc -> {
            class_437 screen = mc.field_1755;
            if (screen == null) {
                return false;
            }
            for (class_4068 drawable : screen.field_33816) {
                class_339 widget;
                if (drawable instanceof class_339 && WiModsTestHelper.clickButtonInWidget(widget = (class_339)drawable, buttonText)) {
                    return true;
                }
                if (!(drawable instanceof class_353)) continue;
                class_353 list = (class_353)drawable;
                for (class_353.class_354 entry : list.method_25396()) {
                    for (class_339 widget2 : entry.field_18214) {
                        if (!WiModsTestHelper.clickButtonInWidget(widget2, buttonText)) continue;
                        return true;
                    }
                }
            }
            return false;
        });
    }

    public static void clickEditKeybindButton(String translationKey) {
        WiModsTestHelper.waitUntil("edit button for " + translationKey + " is visible", mc -> {
            class_437 screen = mc.field_1755;
            if (!(screen instanceof class_6599)) {
                throw new RuntimeException("clickEditKeybindButton() must be called from the Key Binds screen. Current screen: " + String.valueOf(screen));
            }
            for (class_4068 drawable : screen.field_33816) {
                if (!(drawable instanceof class_459)) continue;
                class_459 list = (class_459)drawable;
                for (class_459.class_461 entry : list.method_25396()) {
                    if (!(entry instanceof class_459.class_462)) continue;
                    class_459.class_462 kbEntry = (class_459.class_462)entry;
                    if (!translationKey.equals(kbEntry.field_2740.method_1431())) continue;
                    int x = kbEntry.field_2739.method_46426() + list.method_46426() + kbEntry.field_2739.method_25368() / 2;
                    int y = kbEntry.field_2739.method_46427() + kbEntry.field_2739.method_25364() / 2;
                    System.out.println("Clicking at " + x + ", " + y);
                    screen.method_25402((double)x, (double)y, 0);
                    screen.method_25406((double)x, (double)y, 0);
                    return true;
                }
            }
            return false;
        });
    }

    private static boolean clickButtonInWidget(class_339 widget, String buttonText) {
        class_4185 button;
        if (widget instanceof class_4185 && buttonText.equals((button = (class_4185)widget).method_25369().getString())) {
            button.method_25306();
            return true;
        }
        if (widget instanceof class_5676) {
            button = (class_5676)widget;
            if (buttonText.equals(button.field_27963.getString())) {
                button.method_25306();
                return true;
            }
        }
        return false;
    }

    public static void setTextFieldText(int index, String text) {
        WiModsTestHelper.waitUntil("text field #" + index + " is visible", mc -> {
            class_437 screen = mc.field_1755;
            if (screen == null) {
                return false;
            }
            int i = 0;
            for (class_4068 drawable : screen.field_33816) {
                if (!(drawable instanceof class_342)) continue;
                class_342 textField = (class_342)drawable;
                if (i == index) {
                    textField.method_1852(text);
                    return true;
                }
                ++i;
            }
            return false;
        });
    }

    public static void setKeyPressState(int key, boolean pressed) {
        WiModsTestHelper.submitAndWait(mc -> mc.field_1774.method_1466(mc.method_22683().method_4490(), key, 0, pressed ? 1 : 0, 0));
    }

    public static void scrollMouse(int horizontal, int vertical) {
        WiModsTestHelper.submitAndWait(mc -> mc.field_1729.method_1598(mc.method_22683().method_4490(), (double)horizontal, (double)vertical));
    }

    public static void closeScreen() {
        WiModsTestHelper.submitAndWait(mc -> mc.method_1507(null));
    }

    public static void openGameMenu() {
        WiModsTestHelper.submitAndWait(mc -> mc.method_1507((class_437)new class_433(true)));
    }

    public static void openInventory() {
        WiModsTestHelper.submitAndWait(mc -> mc.method_1507((class_437)new class_490((class_1657)mc.field_1724)));
    }

    public static void toggleDebugHud() {
        WiModsTestHelper.submitAndWait(mc -> mc.field_1705.method_53531().method_53539());
    }

    public static void setPerspective(class_5498 perspective) {
        WiModsTestHelper.submitAndWait(mc -> mc.field_1690.method_31043(perspective));
    }

    public static void dismissTutorialToasts() {
        WiModsTestHelper.submitAndWait(mc -> mc.method_1577().method_4910(class_1157.field_5653));
    }

    public static void clearChat() {
        WiModsTestHelper.submitAndWait(mc -> mc.field_1705.method_1743().method_1808(true));
    }

    public static void runChatCommand(String command) {
        System.out.println("Running command: /" + command);
        WiModsTestHelper.submitAndWait(mc -> {
            class_634 netHandler = mc.method_1562();
            ParseResults results = netHandler.method_2886().parse(command, (Object)netHandler.method_2875());
            if (!results.getExceptions().isEmpty()) {
                StringBuilder errors = new StringBuilder("Invalid command: " + command);
                for (CommandSyntaxException e : results.getExceptions().values()) {
                    errors.append("\n").append(e.getMessage());
                }
                throw new RuntimeException(errors.toString());
            }
            netHandler.method_45730(command);
        });
        WiModsTestHelper.waitForWorldTicks(1);
    }

    public static void assertOneItemInSlot(int slot, class_1792 item) {
        WiModsTestHelper.submitAndWait(mc -> {
            class_1799 stack = mc.field_1724.method_31548().method_5438(slot);
            if (!stack.method_31574(item) || stack.method_7947() != 1) {
                throw new RuntimeException("Expected 1 " + item.method_7848().getString() + " at slot " + slot + ", found " + stack.method_7947() + " " + stack.method_7909().method_7848().getString() + " instead");
            }
        });
    }

    public static void assertNoItemInSlot(int slot) {
        WiModsTestHelper.submitAndWait(mc -> {
            class_1799 stack = mc.field_1724.method_31548().method_5438(slot);
            if (!stack.method_7960()) {
                throw new RuntimeException("Expected no item in slot " + slot + ", found " + stack.method_7947() + " " + stack.method_7909().method_7848().getString() + " instead");
            }
        });
    }

    private static /* synthetic */ WiModsTestHelper[] $values() {
        return new WiModsTestHelper[0];
    }

    static {
        $VALUES = WiModsTestHelper.$values();
        screenshotCounter = new AtomicInteger(0);
    }
}

