/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.integration.jei.transfer;

import com.mojang.datafixers.util.Either;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_8786;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.common.block.entity.KegBlockEntity;
import umpaz.brewinandchewin.common.block.entity.container.KegMenu;
import umpaz.brewinandchewin.common.crafting.KegFermentingRecipe;
import umpaz.brewinandchewin.common.crafting.KegPouringRecipe;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.integration.jei.transfer.FermentingTransfer;

public class FermentingTransferServer {
    public static void setItems(class_1657 player, KegFermentingRecipe recipe, FermentingTransfer.TransferOperations transferOperations, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean maxTransfer) {
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof KegMenu)) {
            return;
        }
        KegMenu kegMenu = (KegMenu)class_17032;
        Map<class_1735, Pair<class_1735, class_1799>> recipeSlotToRequiredItemStack = FermentingTransferServer.calculateRequiredStacks(transferOperations, player);
        List<Pair<class_1735, Pair<class_1799, Long>>> requiredFluidStacks = FermentingTransferServer.calculateRequiredFluidOrEmptyingStacks(transferOperations.fluidResults, player, (Either<KegFermentingRecipe, KegMenu>)Either.left((Object)recipe));
        List<Pair<class_1735, Pair<class_1799, Long>>> requiredEmptyingStacks = FermentingTransferServer.calculateRequiredFluidOrEmptyingStacks(transferOperations.emptyingResults, player, (Either<KegFermentingRecipe, KegMenu>)Either.right((Object)((Object)kegMenu)));
        if (recipeSlotToRequiredItemStack == null || requiredFluidStacks == null || requiredEmptyingStacks == null) {
            return;
        }
        boolean transferAsCompleteSets = !maxTransfer;
        Map<class_1735, class_1799> recipeSlotToTakenStacks = FermentingTransferServer.takeItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer);
        List<class_1799> emptyingSlotToTakenStacks = FermentingTransferServer.takeFluidOrEmptyingItemsFromInventory(player, kegMenu, requiredEmptyingStacks, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer, false);
        List<class_1799> fluidSlotToTakenStacks = FermentingTransferServer.takeFluidOrEmptyingItemsFromInventory(player, kegMenu, requiredFluidStacks, craftingSlots, inventorySlots, transferAsCompleteSets, maxTransfer, true);
        if (recipeSlotToTakenStacks.isEmpty() && fluidSlotToTakenStacks.isEmpty() && emptyingSlotToTakenStacks.isEmpty()) {
            return;
        }
        boolean sameFluid = recipe.getFluidIngredient().isEmpty() && kegMenu.kegTank.isEmpty() || recipe.getFluidIngredient().isPresent() && recipe.getFluidIngredient().get().ingredient().matches(kegMenu.kegTank.getAbstractedFluid());
        List<class_1799> clearedFluidItems = FermentingTransferServer.extractFromFluidTank(player.method_37908(), emptyingSlotToTakenStacks, kegMenu, false, null);
        if (sameFluid && !maxTransfer) {
            fluidSlotToTakenStacks = clearedFluidItems;
        } else {
            FermentingTransferServer.stowItems(player, inventorySlots, clearedFluidItems);
        }
        List<class_1799> fluidItems = FermentingTransferServer.extractFromFluidTank(player.method_37908(), fluidSlotToTakenStacks, kegMenu, true, !maxTransfer ? recipe : null);
        List<class_1799> clearedCraftingItems = FermentingTransferServer.clearCraftingGrid(craftingSlots, player);
        List<class_1799> remainderItems = FermentingTransferServer.putItemsIntoCraftingGrid(recipeSlotToTakenStacks);
        FermentingTransferServer.stowItems(player, inventorySlots, fluidItems);
        FermentingTransferServer.stowItems(player, inventorySlots, clearedCraftingItems);
        FermentingTransferServer.stowItems(player, inventorySlots, remainderItems);
        kegMenu.blockEntity.method_5431();
        player.method_37908().method_8413(kegMenu.blockEntity.method_11016(), kegMenu.blockEntity.method_11010(), kegMenu.blockEntity.method_11010(), 2);
    }

    @NotNull
    private static Map<class_1735, class_1799> takeItemsFromInventory(class_1657 player, Map<class_1735, Pair<class_1735, class_1799>> recipeSlotToRequiredItemStack, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer) {
        Map<class_1735, class_1799> foundItemsInSet;
        if (!maxTransfer) {
            return FermentingTransferServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets);
        }
        HashMap<class_1735, class_1799> recipeSlotToResult = new HashMap<class_1735, class_1799>(recipeSlotToRequiredItemStack.size());
        while (!(foundItemsInSet = FermentingTransferServer.removeOneSetOfItemsFromInventory(player, recipeSlotToRequiredItemStack, craftingSlots, inventorySlots, transferAsCompleteSets)).isEmpty()) {
            Set<class_1735> fullSlots = FermentingTransferServer.merge(recipeSlotToResult, foundItemsInSet);
            for (class_1735 fullSlot : fullSlots) {
                recipeSlotToRequiredItemStack.remove(fullSlot);
            }
        }
        return recipeSlotToResult;
    }

    private static Map<class_1735, class_1799> removeOneSetOfItemsFromInventory(class_1657 player, Map<class_1735, Pair<class_1735, class_1799>> recipeSlotToRequiredItemStack, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<class_1735, class_1799> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<class_1735, class_1799>();
        }
        HashMap<class_1735, class_1799> foundItemsInSet = new HashMap<class_1735, class_1799>(recipeSlotToRequiredItemStack.size());
        for (Map.Entry<class_1735, Pair<class_1735, class_1799>> entry : recipeSlotToRequiredItemStack.entrySet()) {
            class_1735 hint;
            class_1735 recipeSlot = entry.getKey();
            class_1799 requiredStack = (class_1799)entry.getValue().getSecond();
            class_1735 slot = FermentingTransferServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint = (class_1735)entry.getValue().getFirst()).orElse(null);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.method_7677().method_7972());
                }
                class_1799 removedItemStack = slot.method_7671(1);
                foundItemsInSet.put(recipeSlot, removedItemStack);
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                class_1799 stack = (class_1799)slotEntry.getValue();
                ((class_1735)slotEntry.getKey()).method_7673(stack);
            }
            return Map.of();
        }
        return foundItemsInSet;
    }

    @NotNull
    private static List<class_1799> takeFluidOrEmptyingItemsFromInventory(class_1657 player, KegMenu kegMenu, List<Pair<class_1735, Pair<class_1799, Long>>> requiredItemStacks, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean transferAsCompleteSets, boolean maxTransfer, boolean insert) {
        Pair<List<class_1799>, Integer> foundItemsInSet;
        if (!maxTransfer) {
            return (List)FermentingTransferServer.removeOneSetOfFluidOrEmptyingItemsFromInventory(player, requiredItemStacks, craftingSlots, inventorySlots, transferAsCompleteSets).getFirst();
        }
        ArrayList<class_1799> recipeSlotToResult = new ArrayList<class_1799>(requiredItemStacks.size());
        int fluidCapacity = 0;
        while (!(insert && (long)fluidCapacity >= kegMenu.kegTank.getFluidCapacity() || !insert && (long)fluidCapacity >= kegMenu.kegTank.getAbstractedFluid().amount() || ((List)(foundItemsInSet = FermentingTransferServer.removeOneSetOfFluidOrEmptyingItemsFromInventory(player, requiredItemStacks, craftingSlots, inventorySlots, transferAsCompleteSets)).getFirst()).isEmpty())) {
            fluidCapacity += ((Integer)foundItemsInSet.getSecond()).intValue();
            recipeSlotToResult.addAll((Collection)foundItemsInSet.getFirst());
        }
        return recipeSlotToResult;
    }

    private static Pair<List<class_1799>, Integer> removeOneSetOfFluidOrEmptyingItemsFromInventory(class_1657 player, List<Pair<class_1735, Pair<class_1799, Long>>> requiredItemStacks, List<class_1735> craftingSlots, List<class_1735> inventorySlots, boolean transferAsCompleteSets) {
        HashMap<class_1735, class_1799> originalSlotContents = null;
        if (transferAsCompleteSets) {
            originalSlotContents = new HashMap<class_1735, class_1799>();
        }
        ArrayList<class_1799> foundItemsInSet = new ArrayList<class_1799>(requiredItemStacks.size());
        int fluidAmount = 0;
        for (Pair<class_1735, Pair<class_1799, Long>> entry : requiredItemStacks) {
            class_1735 hint;
            class_1799 requiredStack = (class_1799)((Pair)entry.getSecond()).getFirst();
            class_1735 slot = FermentingTransferServer.getSlotWithStack(player, requiredStack, craftingSlots, inventorySlots, hint = (class_1735)entry.getFirst()).orElse(null);
            if (slot != null) {
                if (originalSlotContents != null && !originalSlotContents.containsKey(slot)) {
                    originalSlotContents.put(slot, slot.method_7677().method_7972());
                }
                class_1799 removedItemStack = slot.method_7671(requiredStack.method_7947());
                foundItemsInSet.add(removedItemStack);
                fluidAmount = (int)((long)fluidAmount + (Long)((Pair)entry.getSecond()).getSecond());
                continue;
            }
            if (!transferAsCompleteSets) continue;
            for (Map.Entry slotEntry : originalSlotContents.entrySet()) {
                class_1799 stack = (class_1799)slotEntry.getValue();
                ((class_1735)slotEntry.getKey()).method_7673(stack);
            }
            return Pair.of(List.of(), (Object)0);
        }
        return Pair.of(foundItemsInSet, (Object)fluidAmount);
    }

    private static Set<class_1735> merge(Map<class_1735, class_1799> result, Map<class_1735, class_1799> addition) {
        HashSet<class_1735> fullSlots = new HashSet<class_1735>();
        addition.forEach((slot, itemStack) -> {
            assert (itemStack.method_7947() == 1);
            class_1799 resultItemStack = (class_1799)result.get(slot);
            if (resultItemStack == null) {
                resultItemStack = itemStack;
                result.put((class_1735)slot, resultItemStack);
            } else {
                assert (class_1799.method_31577((class_1799)resultItemStack, (class_1799)itemStack));
                resultItemStack.method_7933(itemStack.method_7947());
            }
            if (resultItemStack.method_7947() == slot.method_7676(resultItemStack)) {
                fullSlots.add((class_1735)slot);
            }
        });
        return fullSlots;
    }

    @Nullable
    private static Map<class_1735, Pair<class_1735, class_1799>> calculateRequiredStacks(FermentingTransfer.TransferOperations transferOperations, class_1657 player) {
        HashMap<class_1735, Pair<class_1735, class_1799>> recipeSlotToRequired = new HashMap<class_1735, Pair<class_1735, class_1799>>(transferOperations.results.size());
        for (Pair<class_1735, class_1735> transferOperation : transferOperations.results) {
            class_1735 recipeSlot = (class_1735)transferOperation.getSecond();
            class_1735 inventorySlot = (class_1735)transferOperation.getFirst();
            if (!inventorySlot.method_7674(player)) {
                return null;
            }
            class_1799 slotStack = inventorySlot.method_7677();
            if (slotStack.method_7960()) {
                return null;
            }
            class_1799 stack = slotStack.method_7972();
            stack.method_7939(1);
            recipeSlotToRequired.put(recipeSlot, (Pair<class_1735, class_1799>)Pair.of((Object)inventorySlot, (Object)stack));
        }
        return recipeSlotToRequired;
    }

    @Nullable
    private static List<Pair<class_1735, Pair<class_1799, Long>>> calculateRequiredFluidOrEmptyingStacks(List<Pair<class_1735, Long>> slots, class_1657 player, Either<KegFermentingRecipe, KegMenu> pouringRecipeSource) {
        if (pouringRecipeSource.left().isPresent() && ((KegFermentingRecipe)pouringRecipeSource.left().get()).getFluidIngredient().isEmpty()) {
            return List.of();
        }
        ArrayList<Pair<class_1735, Pair<class_1799, Long>>> recipeSlotToRequired = new ArrayList<Pair<class_1735, Pair<class_1799, Long>>>(slots.size());
        for (Pair<class_1735, Long> inventorySlot : slots) {
            if (!((class_1735)inventorySlot.getFirst()).method_7674(player)) {
                return null;
            }
            class_1799 slotStack = ((class_1735)inventorySlot.getFirst()).method_7677();
            if (slotStack.method_7960()) {
                return null;
            }
            class_1799 stack = slotStack.method_7972();
            int fluidStackAmount = 1;
            List<KegPouringRecipe> pouringRecipes = player.method_37908().method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).filter(kegPouringRecipe -> (pouringRecipeSource.left().isEmpty() || kegPouringRecipe.canFill()) && (Boolean)pouringRecipeSource.map(recipe -> recipe.getFluidIngredient().orElseThrow().ingredient().matches(kegPouringRecipe.getFluid(stack)), menu -> menu.kegTank.getAbstractedFluid().matches(kegPouringRecipe.getFluid(stack))) != false).toList();
            Optional<KegPouringRecipe> optionalData = pouringRecipes.stream().filter(pouring -> {
                if (pouring.isStrict()) {
                    return class_1799.method_31577((class_1799)stack, (class_1799)((class_1799)pouringRecipeSource.map(ignored -> pouring.getOutput(), ignored -> pouring.getContainer())));
                }
                return class_1799.method_7984((class_1799)stack, (class_1799)((class_1799)pouringRecipeSource.map(ignored -> pouring.getOutput(), ignored -> pouring.getContainer())));
            }).findFirst();
            if (optionalData.isPresent()) {
                fluidStackAmount = (int)((Long)pouringRecipeSource.map(fermentingRecipe -> fermentingRecipe.getFluidIngredient().orElseThrow().amount(), kegMenu -> kegMenu.kegTank.getAbstractedFluid().amount()) / optionalData.get().getRawFluid().amount());
            }
            stack.method_7939(fluidStackAmount);
            recipeSlotToRequired.add((Pair<class_1735, Pair<class_1799, Long>>)Pair.of((Object)((class_1735)inventorySlot.getFirst()), (Object)Pair.of((Object)stack, (Object)((Long)inventorySlot.getSecond()))));
        }
        return recipeSlotToRequired;
    }

    private static void stowItems(class_1657 player, List<class_1735> inventorySlots, List<class_1799> itemStacks) {
        for (class_1799 itemStack : itemStacks) {
            class_1799 remainder = FermentingTransferServer.stowItem(inventorySlots, itemStack);
            if (remainder.method_7960() || player.method_31548().method_7394(remainder)) continue;
            player.method_7328(remainder, false);
        }
    }

    private static List<class_1799> extractFromFluidTank(class_1937 level, List<class_1799> emptyingStacks, KegMenu kegMenu, boolean insert, @Nullable KegFermentingRecipe recipe) {
        ArrayList<class_1799> remainderItems = new ArrayList<class_1799>();
        if (insert && (recipe == null || recipe.getFluidIngredient().isEmpty())) {
            return remainderItems;
        }
        KegBlockEntity blockEntity = kegMenu.blockEntity;
        for (class_1799 stack : emptyingStacks) {
            List<KegPouringRecipe> pouringRecipes;
            Optional<KegPouringRecipe> optionalData;
            if (insert && kegMenu.kegTank.getAbstractedFluid().amount() >= recipe.getFluidIngredient().orElseThrow().amount() || !insert && kegMenu.kegTank.isEmpty()) break;
            int toExtract = stack.method_7947();
            if (recipe != null && recipe.getFluidIngredient().isPresent() && (optionalData = (pouringRecipes = level.method_8433().method_30027(BnCRecipeTypes.KEG_POURING).stream().map(class_8786::comp_1933).filter(kegPouringRecipe -> (!insert || kegPouringRecipe.canFill()) && recipe.getFluidIngredient().get().ingredient().matches(kegPouringRecipe.getFluid(stack))).toList()).stream().filter(pouring -> {
                if (pouring.isStrict()) {
                    return class_1799.method_31577((class_1799)stack, (class_1799)pouring.getOutput());
                }
                return class_1799.method_7984((class_1799)stack, (class_1799)pouring.getOutput());
            }).findFirst()).isPresent()) {
                toExtract = (int)(recipe.getFluidIngredient().get().amount() / optionalData.get().getRawFluid().amount());
            }
            List<class_1799> extracted = blockEntity.extractInGui(stack, toExtract);
            for (class_1799 extract : extracted) {
                if (extract.method_7960()) continue;
                remainderItems.add(extract);
            }
        }
        return remainderItems;
    }

    private static List<class_1799> clearCraftingGrid(List<class_1735> craftingSlots, class_1657 player) {
        ArrayList<class_1799> clearedCraftingItems = new ArrayList<class_1799>();
        for (class_1735 craftingSlot : craftingSlots) {
            if (!craftingSlot.method_7674(player) || !craftingSlot.method_7681()) continue;
            class_1799 craftingItem = craftingSlot.method_7671(Integer.MAX_VALUE);
            clearedCraftingItems.add(craftingItem);
        }
        return clearedCraftingItems;
    }

    private static List<class_1799> putItemsIntoCraftingGrid(Map<class_1735, class_1799> recipeSlotToTakenStacks) {
        int slotStackLimit = FermentingTransferServer.getSlotStackLimit(recipeSlotToTakenStacks);
        ArrayList<class_1799> remainderItems = new ArrayList<class_1799>();
        recipeSlotToTakenStacks.forEach((slot, stack) -> {
            if (slot.method_7677().method_7960() && slot.method_7680(stack)) {
                class_1799 remainder = slot.method_32755(stack, slotStackLimit);
                if (!remainder.method_7960()) {
                    remainderItems.add(remainder);
                }
            } else {
                remainderItems.add((class_1799)stack);
            }
        });
        return remainderItems;
    }

    private static int getSlotStackLimit(Map<class_1735, class_1799> recipeSlotToTakenStacks) {
        return recipeSlotToTakenStacks.entrySet().stream().mapToInt(e -> {
            class_1799 transferItem;
            class_1735 craftingSlot = (class_1735)e.getKey();
            if (craftingSlot.method_7680(transferItem = (class_1799)e.getValue())) {
                return craftingSlot.method_7676(transferItem);
            }
            return Integer.MAX_VALUE;
        }).min().orElse(Integer.MAX_VALUE);
    }

    private static class_1799 stowItem(Collection<class_1735> slots, class_1799 stack) {
        if (stack.method_7960()) {
            return class_1799.field_8037;
        }
        class_1799 remainder = stack.method_7972();
        for (class_1735 slot : slots) {
            class_1799 inventoryStack = slot.method_7677();
            if (inventoryStack.method_7960() || !inventoryStack.method_7946()) continue;
            slot.method_32756(remainder);
            if (!remainder.method_7960()) continue;
            return class_1799.field_8037;
        }
        for (class_1735 slot : slots) {
            if (!slot.method_7677().method_7960()) continue;
            slot.method_32756(remainder);
            if (!remainder.method_7960()) continue;
            return class_1799.field_8037;
        }
        return remainder;
    }

    private static Optional<class_1735> getSlotWithStack(class_1657 player, class_1799 stack, List<class_1735> craftingSlots, List<class_1735> inventorySlots, class_1735 hint) {
        return FermentingTransferServer.getSlotWithStack(player, craftingSlots, stack).or(() -> FermentingTransferServer.getValidatedHintSlot(player, stack, hint)).or(() -> FermentingTransferServer.getSlotWithStack(player, inventorySlots, stack));
    }

    private static Optional<class_1735> getValidatedHintSlot(class_1657 player, class_1799 stack, class_1735 hint) {
        if (hint.method_7674(player) && !hint.method_7677().method_7960() && class_1799.method_31577((class_1799)stack, (class_1799)hint.method_7677())) {
            return Optional.of(hint);
        }
        return Optional.empty();
    }

    private static Optional<class_1735> getSlotWithStack(class_1657 player, Collection<class_1735> slots, class_1799 itemStack) {
        return slots.stream().filter(slot -> {
            class_1799 slotStack = slot.method_7677();
            return class_1799.method_31577((class_1799)itemStack, (class_1799)slotStack) && slot.method_7674(player);
        }).findFirst();
    }
}

