/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.fabric.utility;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.minecraft.class_3611;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6895;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9323;
import net.minecraft.class_9326;
import net.minecraft.class_9335;
import org.jetbrains.annotations.Nullable;
import umpaz.brewinandchewin.common.utility.AbstractedFluidIngredient;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.fabric.utility.AmountedFluidVariant;
import umpaz.brewinandchewin.fabric.utility.BnCFabricStreamCodecs;

public class KegFluidIngredient {
    public static final Codec<AbstractedFluidIngredient> CODEC = Codec.either(Exact.CODEC, Tag.CODEC).xmap(Either::unwrap, wrapper -> {
        if (wrapper instanceof Exact) {
            Exact exact = (Exact)wrapper;
            return Either.left((Object)exact);
        }
        if (wrapper instanceof Tag) {
            Tag neoForgeIngredient = (Tag)wrapper;
            return Either.right((Object)neoForgeIngredient);
        }
        throw new UnsupportedOperationException("Unsupported wrapped fluid ingredient class.");
    });
    public static final class_9139<class_9129, AbstractedFluidIngredient> STREAM_CODEC = class_9135.method_57995(Exact.STREAM_CODEC, Tag.STREAM_CODEC).method_56432(Either::unwrap, wrapper -> {
        if (wrapper instanceof Exact) {
            Exact exact = (Exact)wrapper;
            return Either.left((Object)exact);
        }
        if (wrapper instanceof Tag) {
            Tag neoForgeIngredient = (Tag)wrapper;
            return Either.right((Object)neoForgeIngredient);
        }
        throw new UnsupportedOperationException("Unsupported wrapped fluid ingredient class.");
    });

    public static class Exact
    implements AbstractedFluidIngredient {
        public static final Codec<Exact> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_7923.field_41173.method_39673().fieldOf("fluid").forGetter(exact -> exact.displayStack.fluid()), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(exact -> {
            class_9326 class_93262;
            class_9323 patt0$temp = exact.displayStack.components();
            if (patt0$temp instanceof class_9335) {
                class_9335 patched = (class_9335)patt0$temp;
                class_93262 = patched.method_57940();
            } else {
                class_93262 = class_9326.field_49588;
            }
            return class_93262;
        })).apply((Applicative)inst, Exact::new));
        public static final Codec<Exact> ALTERNATIVE_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_7923.field_41173.method_39673().fieldOf("id").forGetter(exact -> exact.displayStack.fluid()), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(exact -> {
            class_9326 class_93262;
            class_9323 patt0$temp = exact.displayStack.components();
            if (patt0$temp instanceof class_9335) {
                class_9335 patched = (class_9335)patt0$temp;
                class_93262 = patched.method_57940();
            } else {
                class_93262 = class_9326.field_49588;
            }
            return class_93262;
        })).apply((Applicative)inst, Exact::new));
        public static final Codec<Exact> CODEC = Codec.withAlternative(DIRECT_CODEC, ALTERNATIVE_CODEC);
        public static final class_9139<class_9129, Exact> STREAM_CODEC = BnCFabricStreamCodecs.FLUID_STACK_WRAPPER.method_56432(Exact::new, exact -> exact.displayStack);
        private final AbstractedFluidStack displayStack;

        private Exact(AbstractedFluidStack displayStack) {
            this.displayStack = displayStack;
        }

        public Exact(class_3611 fluid, class_9335 components) {
            this.displayStack = new AbstractedFluidStack(fluid, 81000L, (class_9323)components, FluidUnit.DROPLET, new AmountedFluidVariant(FluidVariant.of((class_3611)fluid, (class_9326)components.method_57940()), 81000L, FluidUnit.DROPLET));
        }

        public Exact(class_3611 fluid, class_9326 patch) {
            this(fluid, class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)patch));
        }

        public Exact(class_3611 fluid) {
            this(fluid, new class_9335(class_9323.field_49584));
        }

        @Override
        public List<AbstractedFluidStack> displayStacks() {
            return List.of(this.displayStack);
        }

        @Override
        public boolean matches(AbstractedFluidStack wrapper) {
            if (this.displayStack.components().method_57837()) {
                return this.displayStack.fluid().method_15780(wrapper.fluid());
            }
            return this.displayStack.matches(wrapper);
        }
    }

    public static class Tag
    implements AbstractedFluidIngredient {
        public static final Codec<Tag> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_6895.method_40340((class_5321)class_7924.field_41270).fieldOf("tag").forGetter(tag -> tag.fluidTag), (App)class_9326.field_49589.optionalFieldOf("components", (Object)class_9326.field_49588).forGetter(tag -> {
            class_9326 class_93262;
            class_9335 patt0$temp = tag.components;
            if (patt0$temp instanceof class_9335) {
                class_9335 patched = patt0$temp;
                class_93262 = patched.method_57940();
            } else {
                class_93262 = class_9326.field_49588;
            }
            return class_93262;
        })).apply((Applicative)inst, Tag::new));
        public static final class_9139<class_9129, Tag> STREAM_CODEC = class_9139.method_56435((class_9139)class_9135.method_58001((class_5321)class_7924.field_41270), tag -> tag.fluidTag, (class_9139)class_9326.field_49590, tag -> tag.components.method_57940(), Tag::new);
        private final class_6885<class_3611> fluidTag;
        private final class_9335 components;
        private final List<AbstractedFluidStack> fluidStacks = new ArrayList<AbstractedFluidStack>();

        public Tag(class_6885<class_3611> fluidTag, class_9335 components) {
            this.fluidTag = fluidTag;
            this.components = components;
        }

        public Tag(class_6885<class_3611> fluid, class_9326 patch) {
            this(fluid, class_9335.method_57935((class_9323)class_9323.field_49584, (class_9326)patch));
        }

        public Tag(class_6885<class_3611> fluid) {
            this(fluid, new class_9335(class_9323.field_49584));
        }

        @Nullable
        public class_6862<class_3611> getTagKey() {
            return this.fluidTag.method_45925().orElse(null);
        }

        @Override
        public List<AbstractedFluidStack> displayStacks() {
            if (this.fluidTag.method_40247() > 0 && this.fluidStacks.isEmpty()) {
                for (class_6880 fluidHolder : this.fluidTag) {
                    this.fluidStacks.add(new AbstractedFluidStack((class_3611)fluidHolder.comp_349(), 81000L, (class_9323)this.components, FluidUnit.DROPLET, new AmountedFluidVariant(FluidVariant.of((class_3611)((class_3611)fluidHolder.comp_349()), (class_9326)this.components.method_57940()), 81000L, FluidUnit.DROPLET)));
                }
            }
            return this.fluidStacks;
        }

        @Override
        public boolean matches(AbstractedFluidStack wrapper) {
            if (this.components.method_57837()) {
                return this.fluidTag.method_40241((class_6880)wrapper.fluid().method_40178());
            }
            return this.fluidTag.method_40241((class_6880)wrapper.fluid().method_40178()) && wrapper.components().equals((Object)this.components);
        }
    }
}

