/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common.crafting;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import umpaz.brewinandchewin.client.recipebook.FermentingBookCategory;
import umpaz.brewinandchewin.common.BnCConfiguration;
import umpaz.brewinandchewin.common.crafting.FluidIngredientWithAmount;
import umpaz.brewinandchewin.common.registry.BnCItems;
import umpaz.brewinandchewin.common.registry.BnCRecipeSerializers;
import umpaz.brewinandchewin.common.registry.BnCRecipeTypes;
import umpaz.brewinandchewin.common.utility.AbstractedFluidStack;
import umpaz.brewinandchewin.common.utility.BnCRecipeUtils;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.common.utility.KegRecipeWrapper;

public class KegFermentingRecipe
implements class_1860<KegRecipeWrapper> {
    public static final int INPUT_SLOTS = 4;
    private final class_2371<class_1856> inputItems;
    private final Optional<FluidIngredientWithAmount> fluidIngredient;
    private final Optional<FluidUnit> unit;
    private final FermentingBookCategory tab;
    private final Either<AbstractedFluidStack, class_1799> result;
    private final float experience;
    private final int fermentTime;
    private final int temperature;

    public KegFermentingRecipe(class_2371<class_1856> inputItems, FermentingBookCategory tab, Optional<FluidIngredientWithAmount> fluidIngredient, Optional<FluidUnit> unit, Either<AbstractedFluidStack, class_1799> result, float experience, int fermentTime, int temperature) {
        this.inputItems = inputItems;
        this.tab = tab;
        this.fluidIngredient = fluidIngredient;
        this.unit = unit;
        this.result = unit.isPresent() && result.left().isPresent() ? Either.left((Object)new AbstractedFluidStack(((AbstractedFluidStack)result.left().get()).fluid(), ((AbstractedFluidStack)result.left().get()).amount(), ((AbstractedFluidStack)result.left().get()).components(), unit.get(), ((AbstractedFluidStack)result.left().get()).loaderSpecific())) : result;
        this.experience = experience;
        this.fermentTime = fermentTime;
        this.temperature = temperature;
    }

    public FermentingBookCategory getRecipeBookCategory() {
        return this.tab;
    }

    public class_2371<class_1856> method_8117() {
        return this.inputItems;
    }

    public Optional<FluidIngredientWithAmount> getFluidIngredient() {
        return this.fluidIngredient;
    }

    public Optional<FluidUnit> getRawUnit() {
        return this.unit;
    }

    public FluidUnit getUnit() {
        return this.unit.orElse(FluidUnit.getLoaderUnit());
    }

    public Either<AbstractedFluidStack, class_1799> getResult() {
        return this.result;
    }

    public class_1799 assemble(KegRecipeWrapper inv, class_7225.class_7874 access) {
        return class_1799.field_8037;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getFermentTime() {
        return this.fermentTime;
    }

    public int getTemperature() {
        return this.temperature;
    }

    public boolean matches(KegRecipeWrapper inv, class_1937 level) {
        ArrayList<class_1799> inputs = new ArrayList<class_1799>();
        for (int j = 0; j < 4; ++j) {
            class_1799 itemstack = inv.method_59984(j);
            if (!itemstack.method_7960()) {
                inputs.add(itemstack);
                continue;
            }
            inputs.add(class_1799.field_8037);
        }
        class_9694 input = class_9694.method_59986((int)2, (int)2, inputs);
        return input.method_59983() == 1 && this.inputItems.size() == 1 ? ((class_1856)this.inputItems.getFirst()).method_8093(input.method_59984(0)) : input.method_59988().method_7402((class_1860)this, null) && (this.fluidIngredient.isEmpty() && inv.getFluid().isEmpty() || this.fluidIngredient.isPresent() && !inv.getFluid().isEmpty() && this.fluidIngredient.get().ingredient().matches(inv.getFluid()) && inv.getFluid().amount() % this.fluidIngredient.get().amount() == 0L);
    }

    public boolean method_8113(int width, int height) {
        return width * height >= this.inputItems.size();
    }

    public class_1799 method_8110(class_7225.class_7874 registryAccess) {
        if (this.result.right().isPresent()) {
            return ((class_1799)this.result.right().get()).method_7972();
        }
        if (this.result.left().isPresent()) {
            return BnCRecipeUtils.getPouredItemFromFluid(new AbstractedFluidStack(((AbstractedFluidStack)this.result.left().get()).fluid(), ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().localizedCapacity(), ((AbstractedFluidStack)this.result.left().get()).components(), ((BnCConfiguration.Common)BnCConfiguration.COMMON_CONFIG.get()).keg().capacityUnit(), null));
        }
        return class_1799.field_8037;
    }

    public class_1865<?> method_8119() {
        return BnCRecipeSerializers.FERMENTING;
    }

    public class_3956<?> method_17716() {
        return BnCRecipeTypes.FERMENTING;
    }

    public class_1799 method_17447() {
        return new class_1799((class_1935)BnCItems.KEG);
    }

    public boolean method_31584() {
        class_2371<class_1856> nonnulllist = this.method_8117();
        return nonnulllist.isEmpty() || nonnulllist.stream().allMatch(class_1856::method_8103);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KegFermentingRecipe that = (KegFermentingRecipe)o;
        if (Float.compare(that.getExperience(), this.getExperience()) != 0) {
            return false;
        }
        if (this.getFermentTime() != that.getFermentTime()) {
            return false;
        }
        if (this.getTemperature() != that.getTemperature()) {
            return false;
        }
        if (this.getResult() != that.getResult()) {
            return false;
        }
        if (this.getFluidIngredient() != that.getFluidIngredient()) {
            return false;
        }
        return this.inputItems.equals(that.inputItems);
    }

    public int hashCode() {
        return Objects.hash(this.inputItems, this.fluidIngredient, this.result, Float.valueOf(this.experience), this.fermentTime, this.temperature);
    }

    public static class Serializer
    implements class_1865<KegFermentingRecipe> {
        public static final MapCodec<KegFermentingRecipe> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)class_1856.field_46095.listOf(1, 4).xmap(ingredients -> class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])ingredients.toArray(class_1856[]::new))), Function.identity()).fieldOf("ingredients").forGetter(KegFermentingRecipe::method_8117), (App)FermentingBookCategory.CODEC.optionalFieldOf("category", (Object)FermentingBookCategory.DRINKS).forGetter(KegFermentingRecipe::getRecipeBookCategory), (App)FluidIngredientWithAmount.CODEC.optionalFieldOf("base_fluid").forGetter(KegFermentingRecipe::getFluidIngredient), (App)FluidUnit.CODEC.optionalFieldOf("unit").forGetter(KegFermentingRecipe::getRawUnit), (App)Codec.either(AbstractedFluidStack.CODEC, (Codec)class_1799.field_24671).fieldOf("result").forGetter(KegFermentingRecipe::getResult), (App)Codec.FLOAT.optionalFieldOf("experience", (Object)Float.valueOf(0.0f)).forGetter(KegFermentingRecipe::getExperience), (App)Codec.INT.optionalFieldOf("fermenting_time", (Object)9600).forGetter(KegFermentingRecipe::getFermentTime), (App)Codec.INT.optionalFieldOf("temperature", (Object)3).forGetter(KegFermentingRecipe::getTemperature)).apply((Applicative)inst, KegFermentingRecipe::new));
        public static final class_9139<class_9129, KegFermentingRecipe> STREAM_CODEC = class_9139.method_56437(Serializer::toNetwork, Serializer::fromNetwork);

        public MapCodec<KegFermentingRecipe> method_53736() {
            return CODEC;
        }

        public class_9139<class_9129, KegFermentingRecipe> method_56104() {
            return STREAM_CODEC;
        }

        public static void toNetwork(class_9129 buf, KegFermentingRecipe recipe) {
            class_1856.field_48355.method_56433(class_9135.method_58000((int)4)).encode((Object)buf, recipe.method_8117());
            FermentingBookCategory.STREAM_CODEC.encode((Object)buf, (Object)recipe.getRecipeBookCategory());
            class_9135.method_56382(FluidIngredientWithAmount.STREAM_CODEC).encode((Object)buf, recipe.getFluidIngredient());
            class_9135.method_56382(FluidUnit.STREAM_CODEC).encode((Object)buf, recipe.getRawUnit());
            class_9135.method_57995(AbstractedFluidStack.STREAM_CODEC, (class_9139)class_1799.field_48349).encode((Object)buf, recipe.getResult());
            buf.method_52941(recipe.getExperience());
            buf.method_53002(recipe.getFermentTime());
            buf.method_53002(recipe.getTemperature());
        }

        public static KegFermentingRecipe fromNetwork(class_9129 buf) {
            class_2371 ingredients = class_2371.method_10212((Object)class_1856.field_9017, (Object[])((class_1856[])((List)class_1856.field_48355.method_56433(class_9135.method_58000((int)4)).decode((Object)buf)).toArray(class_1856[]::new)));
            FermentingBookCategory category = (FermentingBookCategory)((Object)FermentingBookCategory.STREAM_CODEC.decode((Object)buf));
            Optional fluidIngredient = (Optional)class_9135.method_56382(FluidIngredientWithAmount.STREAM_CODEC).decode((Object)buf);
            Optional fluidUnit = (Optional)class_9135.method_56382(FluidUnit.STREAM_CODEC).decode((Object)buf);
            Either result = (Either)class_9135.method_57995(AbstractedFluidStack.STREAM_CODEC, (class_9139)class_1799.field_48349).decode((Object)buf);
            float experience = buf.readFloat();
            int fermentingTime = buf.readInt();
            int temperature = buf.readInt();
            return new KegFermentingRecipe((class_2371<class_1856>)ingredients, category, fluidIngredient, fluidUnit, (Either<AbstractedFluidStack, class_1799>)result, experience, fermentingTime, temperature);
        }
    }
}

