/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.common;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import house.greenhouse.greenhouseconfig.api.GreenhouseConfigHolder;
import house.greenhouse.greenhouseconfig.api.lang.ConfigLang;
import house.greenhouse.greenhouseconfig.api.util.DefaultFieldUtil;
import house.greenhouse.greenhouseconfig.impl.codec.OrderCorrectedRecordCodec;
import house.greenhouse.greenhouseconfig.toml.TomlLang;
import io.netty.buffer.ByteBuf;
import net.minecraft.class_3542;
import net.minecraft.class_5699;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.common.utility.FluidUnit;
import umpaz.brewinandchewin.platform.BnCPlatform;

public class BnCConfiguration {
    public static final GreenhouseConfigHolder<Common> COMMON_CONFIG = GreenhouseConfigHolder.common((String)"brewinandchewin-common", Common.CODEC, (Object)Common.DEFAULT, (ConfigLang)TomlLang.INSTANCE).networkSynchronized(Common.STREAM_CODEC.method_56430()).build();
    public static final GreenhouseConfigHolder<Client> CLIENT_CONFIG = GreenhouseConfigHolder.client((String)"brewinandchewin-client", Client.CODEC, (Object)Client.DEFAULT, (ConfigLang)TomlLang.INSTANCE).build();

    public static void init() {
    }

    private static <T> T platformSpecificValue(T neoForge, T fabric) {
        return BrewinAndChewin.getHelper().getPlatform() == BnCPlatform.NEOFORGE ? neoForge : fabric;
    }

    public record Common(Root root, Keg keg, RecipeBook recipeBook) {
        public static final Common DEFAULT = new Common(Root.DEFAULT, Keg.DEFAULT, RecipeBook.DEFAULT);
        private static final Codec<Common> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)Root.CODEC.forGetter(Common::root), (App)Keg.CODEC.fieldOf("keg").forGetter(Common::keg), (App)RecipeBook.CODEC.fieldOf("recipe_book").forGetter(Common::recipeBook)).apply((Applicative)inst, Common::new));
        public static final class_9139<ByteBuf, Common> STREAM_CODEC = class_9139.method_56436(Root.STREAM_CODEC, Common::root, Keg.STREAM_CODEC, Common::keg, RecipeBook.STREAM_CODEC, Common::recipeBook, Common::new);

        public record Root(int levelChatScramble, int levelSignScramble, int levelNameScramble) {
            public static final Root DEFAULT = new Root(3, 3, 3);
            public static final MapCodec<Root> CODEC = RecordCodecBuilder.mapCodec(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.intRange((int)1, (int)10), (String)"levelChatScramble", (Object)DEFAULT.levelChatScramble(), (String[])new String[]{"At what amplifier of Tipsy should the chat scramble?", "Default: " + DEFAULT.levelChatScramble()}).forGetter(Root::levelChatScramble), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.intRange((int)1, (int)10), (String)"levelSignScramble", (Object)DEFAULT.levelSignScramble(), (String[])new String[]{"At what amplifier of Tipsy should signs scramble?", "Default: " + DEFAULT.levelSignScramble()}).forGetter(Root::levelSignScramble), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.intRange((int)1, (int)10), (String)"levelNameScramble", (Object)DEFAULT.levelNameScramble(), (String[])new String[]{"At what amplifier of Tipsy should nametags scramble?", "Default: " + DEFAULT.levelNameScramble()}).forGetter(Root::levelNameScramble)).apply((Applicative)inst, Root::new));
            public static final class_9139<ByteBuf, Root> STREAM_CODEC = class_9139.method_56436((class_9139)class_9135.field_49675, Root::levelChatScramble, (class_9139)class_9135.field_49675, Root::levelSignScramble, (class_9139)class_9135.field_49675, Root::levelNameScramble, Root::new);
        }

        public record Keg(FluidUnit capacityUnit, long capacity, int cold, int chilly, int warm, int hot, boolean biomeTemp, boolean dimTemp) {
            public static final Keg DEFAULT = new Keg(BnCConfiguration.platformSpecificValue(FluidUnit.MILLIBUCKET, FluidUnit.DROPLET), BnCConfiguration.platformSpecificValue(1000L, 81000L), 2, 1, 1, 2, true, true);
            public static final Codec<Keg> CODEC = OrderCorrectedRecordCodec.wrap((Codec)RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments(FluidUnit.CODEC, (String)"kegCapacityUnit", (Object)((Object)DEFAULT.capacityUnit()), (String[])new String[]{"Which unit the capacity field should use.", "Should be 'liters', 'millibuckets' or 'droplets'", "1 L = 1 mB = 81 d", "Default: " + DEFAULT.capacityUnit().method_15434()}).forGetter(Keg::capacityUnit), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.LONG.validate(l -> {
                if (l < 0L) {
                    return DataResult.error(() -> "Keg capacity cannot be below 0.");
                }
                return DataResult.success((Object)l);
            }), (String)"kegCapacity", (Object)DEFAULT.capacity(), (String[])new String[]{"How much fluid (unit specified by capacityUnit) can the Keg hold?", "Range: 1 ~ " + FluidUnit.convert(10000L, FluidUnit.MILLIBUCKET, DEFAULT.capacityUnit()), "Default: " + DEFAULT.capacity() + "(" + DEFAULT.capacityUnit().method_15434() + ")"}).forGetter(Keg::capacity), (App)DefaultFieldUtil.codecWithComments((Codec)class_5699.field_33442, (String)"kegCold", (Object)DEFAULT.cold(), (String[])new String[]{"How many cold blocks are required for a cold temperature in the Keg?", "Default: " + DEFAULT.cold()}).forGetter(Keg::cold), (App)DefaultFieldUtil.codecWithComments((Codec)class_5699.field_33442, (String)"kegChilly", (Object)DEFAULT.chilly(), (String[])new String[]{"How many cold blocks are required for a chilly temperature in the Keg?", "Default: " + DEFAULT.chilly()}).forGetter(Keg::chilly), (App)DefaultFieldUtil.codecWithComments((Codec)class_5699.field_33442, (String)"kegWarm", (Object)DEFAULT.warm(), (String[])new String[]{"How many hot blocks are required for a warm temperature in the Keg?", "Default: " + DEFAULT.warm()}).forGetter(Keg::warm), (App)DefaultFieldUtil.codecWithComments((Codec)class_5699.field_33442, (String)"kegHot", (Object)DEFAULT.hot(), (String[])new String[]{"How many hot blocks are required for a hot temperature in the Keg?", "Default: " + DEFAULT.hot()}).forGetter(Keg::hot), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"kegBiomeTemp", (Object)DEFAULT.biomeTemp(), (String[])new String[]{"Should the biome temperature influence the temperature in the Keg?", "Default: " + DEFAULT.biomeTemp()}).forGetter(Keg::biomeTemp), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"kegDimTemp", (Object)DEFAULT.dimTemp(), (String[])new String[]{"Should the dimension temperature influence the temperature in the Keg?", "Default: " + DEFAULT.dimTemp()}).forGetter(Keg::dimTemp)).apply((Applicative)inst, Keg::new)));
            public static final class_9139<ByteBuf, Keg> STREAM_CODEC = class_9139.method_56437(Keg::encode, Keg::new);

            public Keg(ByteBuf buf) {
                this((FluidUnit)((Object)FluidUnit.STREAM_CODEC.decode((Object)buf)), buf.readLong(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readInt(), buf.readBoolean(), buf.readBoolean());
            }

            public long localizedCapacity() {
                return this.capacityUnit.convertToLoader(this.capacity);
            }

            public static void encode(ByteBuf buf, Keg keg) {
                FluidUnit.STREAM_CODEC.encode((Object)buf, (Object)keg.capacityUnit());
                buf.writeLong(keg.capacity);
                buf.writeInt(keg.cold);
                buf.writeInt(keg.chilly);
                buf.writeInt(keg.warm);
                buf.writeInt(keg.hot);
                buf.writeBoolean(keg.biomeTemp);
                buf.writeBoolean(keg.dimTemp);
            }
        }

        public record RecipeBook(boolean enabled) {
            public static final RecipeBook DEFAULT = new RecipeBook(true);
            public static final Codec<RecipeBook> CODEC = RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"enableRecipeBookKeg", (Object)DEFAULT.enabled(), (String[])new String[]{"Should the Keg have a Recipe Book available on its interface?", "Default: " + DEFAULT.enabled()}).forGetter(RecipeBook::enabled)).apply((Applicative)inst, RecipeBook::new));
            public static final class_9139<ByteBuf, RecipeBook> STREAM_CODEC = class_9135.field_48547.method_56432(RecipeBook::new, RecipeBook::enabled);
        }
    }

    public record Client(FluidUnit displayUnit, DisplaySettings oppositeFluidDisplay, boolean numbedHeartFlickering, boolean intoxicationFoodOverlay, boolean scrambleChat, boolean scrambleName, boolean scrambleSign, boolean renderFluidInKeg) {
        public static final Client DEFAULT = new Client(BnCConfiguration.platformSpecificValue(FluidUnit.MILLIBUCKET, FluidUnit.LITER), BnCConfiguration.platformSpecificValue(DisplaySettings.NEVER, DisplaySettings.ADVANCED_TOOLTIPS), true, true, true, true, true, true);
        private static final Codec<Client> CODEC = OrderCorrectedRecordCodec.wrap((Codec)RecordCodecBuilder.create(inst -> inst.group((App)DefaultFieldUtil.codecWithComments(FluidUnit.CODEC, (String)"fluidDisplayUnit", (Object)((Object)DEFAULT.displayUnit()), (String[])new String[]{"Which unit the fluid display in the keg should use.", "Should be 'liters', 'millibuckets' or 'droplets'", "1 L = 1 mB = 81 d", "Default: " + DEFAULT.displayUnit().method_15434()}).forGetter(Client::displayUnit), (App)DefaultFieldUtil.codecWithComments(DisplaySettings.CODEC, (String)"oppositeFluidDisplay", (Object)((Object)DEFAULT.oppositeFluidDisplay()), (String[])new String[]{"When the opposite fluid display unit should be shown.", "Should be one of 'never', 'advanced_tooltips' or 'always'", "Default: " + DEFAULT.oppositeFluidDisplay().method_15434()}).forGetter(Client::oppositeFluidDisplay), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"numbedHeartFlickering", (Object)DEFAULT.numbedHeartFlickering(), (String[])new String[]{"Should the numbed hearts obtained from being damaged when Tipsy flicker when you are about to take damage?", "Default: " + DEFAULT.numbedHeartFlickering()}).forGetter(Client::numbedHeartFlickering), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"intoxicationFoodOverlay", (Object)DEFAULT.intoxicationFoodOverlay(), (String[])new String[]{"Should the food bar have a yellow overlay when the player has the Intoxication effect?", "Default: " + DEFAULT.intoxicationFoodOverlay()}).forGetter(Client::intoxicationFoodOverlay), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"scrambleChat", (Object)DEFAULT.scrambleChat(), (String[])new String[]{"Should the chat scramble when the player has the Tipsy effect?", "Default: " + DEFAULT.scrambleChat()}).forGetter(Client::scrambleChat), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"scrambleName", (Object)DEFAULT.scrambleName(), (String[])new String[]{"Should other player's nametags scramble when the player has the Tipsy effect?", "Default: " + DEFAULT.scrambleName()}).forGetter(Client::scrambleName), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"scrambleSign", (Object)DEFAULT.scrambleSign(), (String[])new String[]{"Should signs scramble when the player has the Tipsy effect?", "Default: " + DEFAULT.scrambleSign()}).forGetter(Client::scrambleSign), (App)DefaultFieldUtil.codecWithComments((Codec)Codec.BOOL, (String)"renderFluidInKeg", (Object)DEFAULT.renderFluidInKeg(), (String[])new String[]{"Should kegs render the fluid texture in the background of the fluid slot?", "Default: " + DEFAULT.renderFluidInKeg()}).forGetter(Client::scrambleSign)).apply((Applicative)inst, Client::new)));

        public static enum DisplaySettings implements class_3542
        {
            NEVER("never"),
            ADVANCED_TOOLTIPS("advanced_tooltips"),
            ALWAYS("always");

            public static final Codec<DisplaySettings> CODEC;
            final String name;

            private DisplaySettings(String name) {
                this.name = name;
            }

            @NotNull
            public String method_15434() {
                return this.name;
            }

            static {
                CODEC = class_3542.method_28140(DisplaySettings::values);
            }
        }
    }
}

