/*
 * Decompiled with CFR 0.152.
 */
package umpaz.brewinandchewin.client.renderer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5614;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_7833;
import net.minecraft.class_7923;
import net.minecraft.class_811;
import net.minecraft.class_827;
import org.joml.Quaternionf;
import org.joml.Vector2f;
import umpaz.brewinandchewin.BrewinAndChewin;
import umpaz.brewinandchewin.client.BrewinAndChewinClient;
import umpaz.brewinandchewin.client.renderer.texture.BnCTextureModifiers;
import umpaz.brewinandchewin.client.renderer.texture.modifier.TextureModifier;
import umpaz.brewinandchewin.common.block.CoasterBlock;
import umpaz.brewinandchewin.common.block.entity.CoasterBlockEntity;

public class CoasterBlockEntityRenderer
implements class_827<CoasterBlockEntity> {
    private static final Map<class_2960, List<ModelEntry>> ITEM_TO_MODELS = new HashMap<class_2960, List<ModelEntry>>();
    private static final Set<class_2960> ERRONEOUS_ENTRIES = new HashSet<class_2960>();

    public static void resetCache() {
        ITEM_TO_MODELS.clear();
        ERRONEOUS_ENTRIES.clear();
    }

    public static List<ModelEntry> getModelEntries(class_2960 itemId) {
        return ITEM_TO_MODELS.get(itemId);
    }

    public static void addToModelMap(class_2960 itemId, List<ModelEntry> models) {
        ITEM_TO_MODELS.put(itemId, models);
    }

    public CoasterBlockEntityRenderer(class_5614.class_5615 context) {
    }

    private void poseUtil(class_4587 poseStack, int fullCount, int curCount, class_5819 seededRandom, boolean invisible) {
        Vector2f translateVec = switch (fullCount) {
            case 2 -> {
                if (curCount == 0) {
                    yield new Vector2f(-0.2f, -0.15f);
                }
                yield new Vector2f(0.2f, 0.15f);
            }
            case 3 -> {
                if (curCount == 0) {
                    yield new Vector2f(0.05f, 0.25f);
                }
                if (curCount == 1) {
                    yield new Vector2f(-0.25f, -0.15f);
                }
                yield new Vector2f(0.25f, -0.25f);
            }
            case 4 -> {
                if (curCount == 0) {
                    yield new Vector2f(0.2f, 0.25f);
                }
                if (curCount == 1) {
                    yield new Vector2f(-0.25f, 0.2f);
                }
                if (curCount == 2) {
                    yield new Vector2f(0.25f, -0.2f);
                }
                yield new Vector2f(-0.2f, -0.25f);
            }
            default -> new Vector2f();
        };
        float rotation = switch (fullCount) {
            case 2 -> {
                if (curCount == 0) {
                    yield 190.0f;
                }
                yield 10.0f;
            }
            case 3 -> {
                if (curCount == 0) {
                    yield -20.0f;
                }
                if (curCount == 1) {
                    yield 220.0f;
                }
                yield 100.0f;
            }
            case 4 -> {
                if (curCount == 0) {
                    yield -5.0f;
                }
                if (curCount == 1) {
                    yield 265.0f;
                }
                if (curCount == 2) {
                    yield 85.0f;
                }
                yield 175.0f;
            }
            default -> 0.0f;
        };
        poseStack.method_49278(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, rotation + seededRandom.method_43057() * 20.0f - 10.0f), 0.5f + translateVec.x(), 0.0f, 0.5f + translateVec.y());
        poseStack.method_22904((double)translateVec.x(), invisible ? 0.0 : 0.0625, (double)translateVec.y());
    }

    public void render(CoasterBlockEntity entity, float tickDelta, class_4587 poseStack, class_4597 buffer, int combinedLight, int combinedOverlay) {
        int count = (int)entity.getItems().stream().filter(i -> !i.method_7960()).count();
        poseStack.method_49278(new Quaternionf().fromAxisAngleDeg(0.0f, 1.0f, 0.0f, -22.5f * (float)((Integer)entity.method_11010().method_11654((class_2769)CoasterBlock.ROTATION)).intValue()), 0.5f, 0.0f, 0.5f);
        class_5820 random = new class_5820(entity.method_11016().method_10063());
        if (!((Boolean)entity.method_11010().method_11654((class_2769)CoasterBlock.INVISIBLE)).booleanValue() || count == 0) {
            poseStack.method_22903();
            class_2960 modelId = (Integer)entity.method_11010().method_11654((class_2769)CoasterBlock.SIZE) > 1 ? BrewinAndChewin.asResource("block/coaster_tray") : BrewinAndChewin.asResource("block/coaster");
            BrewinAndChewinClient.getHelper().tesselateCoasterModel((class_1920)entity.method_10997(), modelId, entity.method_11010(), entity.method_11016(), poseStack, buffer, (class_5819)random, entity.method_11016().method_10063(), combinedOverlay, -1, class_1921.method_23581());
            poseStack.method_22909();
        }
        int tintIndex = -1;
        for (int i2 = 0; i2 < count; ++i2) {
            class_1799 stack = (class_1799)entity.getItems().get(i2);
            class_2960 itemId = class_7923.field_41178.method_10221((Object)stack.method_7909());
            List<ModelEntry> modelEntries = CoasterBlockEntityRenderer.getModelEntries(itemId);
            poseStack.method_22903();
            this.poseUtil(poseStack, count, i2, (class_5819)random, (Boolean)entity.method_11010().method_11654((class_2769)CoasterBlock.INVISIBLE));
            if (modelEntries != null) {
                for (ModelEntry modelEntry : modelEntries) {
                    class_2960 modelPath = modelEntry.model.method_45134(path -> "brewinandchewin/coaster/" + path);
                    if (!CoasterBlockEntityRenderer.checkModel(modelPath)) continue;
                    int color = -1;
                    class_1921 renderType = class_1921.method_23581();
                    for (int j = 0; j < modelEntry.modifiers().size(); ++j) {
                        for (TextureModifier textureModifier : modelEntry.modifiers()) {
                            color = textureModifier.color((class_1920)entity.method_10997(), entity.method_11010(), entity.method_11016(), stack, color);
                            renderType = textureModifier.renderType((class_1920)entity.method_10997(), entity.method_11010(), entity.method_11016(), stack, renderType);
                        }
                    }
                    int finalTintIndex = -1;
                    if (color != -1) {
                        finalTintIndex = ++tintIndex;
                    }
                    BrewinAndChewinClient.getHelper().tesselateCoasterModel((class_1920)entity.method_10997(), modelPath, entity.method_11010(), entity.method_11016(), poseStack, buffer, (class_5819)random, entity.method_11016().method_10063(), combinedOverlay, finalTintIndex, renderType);
                }
            } else {
                poseStack.method_22904(0.51, 0.05, 0.5);
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(90.0f));
                poseStack.method_22905(0.5f, 0.5f, 0.5f);
                class_310.method_1551().method_1480().method_23178(stack, class_811.field_4319, combinedLight, combinedOverlay, poseStack, buffer, entity.method_10997(), (int)entity.method_11016().method_10063());
            }
            poseStack.method_22909();
        }
    }

    public class_238 getRenderBoundingBox(CoasterBlockEntity blockEntity) {
        return blockEntity.getRenderBoundingBox();
    }

    public static boolean checkModel(class_2960 path) {
        class_1087 model = BrewinAndChewinClient.getHelper().getModel(path);
        if (!ERRONEOUS_ENTRIES.contains(path) && model == class_310.method_1551().method_1554().method_4744()) {
            BrewinAndChewin.LOG.error("Failed to get model '{}'", (Object)path.method_45134(p -> p.substring(24)));
            ERRONEOUS_ENTRIES.add(path);
            return false;
        }
        return true;
    }

    public record ModelEntry(class_2960 model, List<? extends TextureModifier> modifiers) {
        private static final Codec<ModelEntry> DIRECT_CODEC = RecordCodecBuilder.create(inst -> inst.group((App)class_2960.field_25139.fieldOf("model").forGetter(ModelEntry::model), (App)BnCTextureModifiers.CODEC.listOf().optionalFieldOf("texture_modifiers", List.of()).forGetter(modelEntry -> modelEntry.modifiers())).apply((Applicative)inst, ModelEntry::new));
        public static final Codec<List<ModelEntry>> LIST_CODEC = Codec.either((Codec)class_2960.field_25139, (Codec)DIRECT_CODEC.listOf()).xmap(either -> (List)either.map(resourceLocation -> List.of(new ModelEntry((class_2960)resourceLocation, List.of())), Function.identity()), modelEntry -> {
            if (modelEntry.size() == 1 && ((ModelEntry)modelEntry.get(0)).modifiers().isEmpty()) {
                return Either.left((Object)((ModelEntry)modelEntry.get(0)).model());
            }
            return Either.right((Object)modelEntry);
        });
    }
}

