/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.api.view;

import com.google.common.collect.Lists;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class ViewGroup<T> {
    public List<T> views;
    @Nullable
    public String id;
    @Nullable
    protected class_2487 extraData;

    public static <B extends ByteBuf, T> class_9139<B, ViewGroup<T>> codec(class_9139<B, T> viewCodec) {
        return class_9139.method_56436((class_9139)class_9135.method_56363().apply(viewCodec), $ -> $.views, (class_9139)class_9135.method_56382((class_9139)class_9135.field_48554), $ -> Optional.ofNullable($.id), (class_9139)class_9135.method_56382((class_9139)class_9135.field_48556), $ -> Optional.ofNullable($.extraData), ViewGroup::new);
    }

    public static <B extends ByteBuf, T> class_9139<B, Map.Entry<class_2960, List<ViewGroup<T>>>> listCodec(class_9139<B, T> viewCodec) {
        return class_9139.method_56435((class_9139)class_2960.field_48267, Map.Entry::getKey, (class_9139)class_9135.method_56363().apply(ViewGroup.codec(viewCodec)), Map.Entry::getValue, Map::entry);
    }

    public ViewGroup(List<T> views) {
        this(views, Optional.empty(), Optional.empty());
    }

    public ViewGroup(List<T> views, Optional<String> id, Optional<class_2487> extraData) {
        this.views = views;
        this.id = id.orElse(null);
        this.extraData = extraData.orElse(null);
    }

    public void save(class_2487 tag, Function<T, class_2487> writer) {
        class_2499 list = new class_2499();
        for (T view : this.views) {
            list.add((Object)((class_2520)writer.apply(view)));
        }
        tag.method_10566("Views", (class_2520)list);
        if (this.id != null) {
            tag.method_10582("Id", this.id);
        }
        if (this.extraData != null) {
            tag.method_10566("Data", (class_2520)this.extraData);
        }
    }

    public static <T> ViewGroup<T> read(class_2487 tag, Function<class_2487, T> reader) {
        class_2499 list = tag.method_10554("Views", 10);
        ArrayList views = Lists.newArrayList();
        for (class_2520 view : list) {
            views.add(reader.apply((class_2487)view));
        }
        ViewGroup<T> group = new ViewGroup<T>(views);
        if (tag.method_10545("Id")) {
            group.id = tag.method_10558("Id");
        }
        if (tag.method_10545("Data")) {
            group.extraData = tag.method_10562("Data");
        }
        return group;
    }

    public static <T> boolean saveList(class_2487 tag, String key, List<ViewGroup<T>> groups, Function<T, class_2487> writer) {
        if (groups == null) {
            return false;
        }
        if (groups.isEmpty()) {
            return true;
        }
        class_2499 groupList = new class_2499();
        for (ViewGroup<T> group : groups) {
            if (group.views.isEmpty()) continue;
            class_2487 groupTag = new class_2487();
            group.save(groupTag, writer);
            groupList.add((Object)groupTag);
        }
        if (!groupList.isEmpty()) {
            tag.method_10566(key, (class_2520)groupList);
        }
        return true;
    }

    @Nullable
    public static <T> List<ViewGroup<T>> readList(class_2487 tag, String key, Function<class_2487, T> reader) {
        class_2499 list = tag.method_10554(key, 10);
        if (list.isEmpty()) {
            return null;
        }
        ArrayList groups = Lists.newArrayList();
        for (class_2520 item : list) {
            ViewGroup<T> group = ViewGroup.read((class_2487)item, reader);
            if (group.views.isEmpty()) continue;
            groups.add(group);
        }
        return groups;
    }

    public class_2487 getExtraData() {
        if (this.extraData == null) {
            this.extraData = new class_2487();
        }
        return this.extraData;
    }

    public void setProgress(float progress) {
        this.getExtraData().method_10548("Progress", progress);
    }
}

