/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners.helpers;

import de.keksuccino.fancymenu.customization.listener.listeners.Listeners;
import java.nio.file.Path;
import net.minecraft.class_1132;
import net.minecraft.class_310;
import net.minecraft.class_5218;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldSessionTracker {
    @Nullable
    private static SessionData activeSession;
    @Nullable
    private static SessionData pendingSession;

    private WorldSessionTracker() {
    }

    public static void prepareSession(@NotNull String worldName, @NotNull String worldSavePath, @Nullable String iconPath, boolean isFirstJoin) {
        String resolvedIconPath = WorldSessionTracker.resolveIconPath(worldSavePath, iconPath);
        pendingSession = new SessionData(worldName, worldSavePath, resolvedIconPath, isFirstJoin);
    }

    public static void clearSession() {
        activeSession = null;
        pendingSession = null;
    }

    public static boolean hasPendingEntry() {
        return pendingSession != null;
    }

    public static void captureSnapshot(@NotNull class_310 minecraft) {
        WorldSessionTracker.captureSnapshotFor(minecraft, activeSession);
    }

    public static void handleWorldEntered(@NotNull class_310 minecraft) {
        if (pendingSession == null) {
            return;
        }
        WorldSessionTracker.captureSnapshotFor(minecraft, pendingSession);
        SessionData session = pendingSession.copy();
        activeSession = pendingSession;
        pendingSession = null;
        Listeners.ON_WORLD_ENTERED.onWorldEntered(session.worldName, session.worldSavePath, session.lastDifficultyKey, session.lastCheatsAllowed, session.iconPath, session.isFirstJoin);
    }

    public static void handleWorldLeft(@NotNull class_310 minecraft) {
        if (activeSession == null) {
            return;
        }
        WorldSessionTracker.captureSnapshot(minecraft);
        SessionData session = activeSession.copy();
        activeSession = null;
        Listeners.ON_WORLD_LEFT.onWorldLeft(session.worldName, session.worldSavePath, session.lastDifficultyKey, session.lastCheatsAllowed, session.iconPath);
    }

    private static void captureSnapshotFor(@NotNull class_310 minecraft, @Nullable SessionData session) {
        class_1132 server;
        if (session == null) {
            return;
        }
        class_638 level = minecraft.field_1687;
        if (level != null) {
            session.lastDifficultyKey = level.method_8407().method_5460();
        }
        if ((server = minecraft.method_1576()) != null) {
            session.lastCheatsAllowed = Boolean.toString(server.method_27728().method_194());
        }
    }

    @NotNull
    private static String resolveIconPath(@NotNull String worldSavePath, @Nullable String iconPath) {
        if (iconPath != null && !iconPath.isBlank()) {
            return iconPath;
        }
        return Path.of(worldSavePath, class_5218.field_38979.method_27423()).toString();
    }

    private static final class SessionData {
        private final String worldName;
        private final String worldSavePath;
        private final String iconPath;
        private final boolean isFirstJoin;
        @Nullable
        private String lastDifficultyKey;
        @Nullable
        private String lastCheatsAllowed;

        private SessionData(String worldName, String worldSavePath, String iconPath, boolean isFirstJoin) {
            this.worldName = worldName;
            this.worldSavePath = worldSavePath;
            this.iconPath = iconPath;
            this.isFirstJoin = isFirstJoin;
        }

        private SessionData copy() {
            SessionData copy = new SessionData(this.worldName, this.worldSavePath, this.iconPath, this.isFirstJoin);
            copy.lastDifficultyKey = this.lastDifficultyKey;
            copy.lastCheatsAllowed = this.lastCheatsAllowed;
            return copy;
        }
    }
}

