/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.listener.listeners;

import de.keksuccino.fancymenu.customization.listener.AbstractListener;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import java.util.List;
import net.minecraft.class_2561;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OnWorldEnteredListener
extends AbstractListener {
    @Nullable
    private String cachedWorldName;
    @Nullable
    private String cachedWorldSavePath;
    @Nullable
    private String cachedWorldDifficulty;
    @Nullable
    private String cachedWorldCheatsAllowed;
    @Nullable
    private String cachedWorldIconPath;
    @Nullable
    private Boolean cachedWorldIsFirstJoin;

    public OnWorldEnteredListener() {
        super("world_entered");
    }

    public void onWorldEntered(@Nullable String worldName, @Nullable String worldSavePath, @Nullable String worldDifficultyKey, @Nullable String cheatsAllowed, @Nullable String worldIconPath, boolean isFirstJoin) {
        this.cachedWorldName = OnWorldEnteredListener.sanitize(worldName);
        this.cachedWorldSavePath = OnWorldEnteredListener.sanitize(worldSavePath);
        this.cachedWorldDifficulty = OnWorldEnteredListener.sanitize(worldDifficultyKey);
        this.cachedWorldCheatsAllowed = OnWorldEnteredListener.sanitize(cheatsAllowed);
        this.cachedWorldIconPath = OnWorldEnteredListener.sanitize(worldIconPath);
        this.cachedWorldIsFirstJoin = isFirstJoin;
        this.notifyAllInstances();
    }

    @Override
    protected void buildCustomVariablesAndAddToList(List<AbstractListener.CustomVariable> list) {
        list.add(new AbstractListener.CustomVariable("world_name", () -> OnWorldEnteredListener.valueOrError(this.cachedWorldName)));
        list.add(new AbstractListener.CustomVariable("world_save_path", () -> OnWorldEnteredListener.valueOrError(this.cachedWorldSavePath)));
        list.add(new AbstractListener.CustomVariable("world_difficulty", () -> OnWorldEnteredListener.valueOrError(this.cachedWorldDifficulty)));
        list.add(new AbstractListener.CustomVariable("world_cheats_allowed", () -> OnWorldEnteredListener.booleanString(this.cachedWorldCheatsAllowed)));
        list.add(new AbstractListener.CustomVariable("world_icon_path", () -> OnWorldEnteredListener.valueOrError(this.cachedWorldIconPath)));
        list.add(new AbstractListener.CustomVariable("world_is_first_join", () -> this.cachedWorldIsFirstJoin != null ? Boolean.toString(this.cachedWorldIsFirstJoin) : "false"));
    }

    @Override
    @NotNull
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"fancymenu.listeners.on_world_entered");
    }

    @Override
    @NotNull
    public List<class_2561> getDescription() {
        return List.of(LocalizationUtils.splitLocalizedLines("fancymenu.listeners.on_world_entered.desc", new String[0]));
    }

    private static String sanitize(@Nullable String value) {
        if (value == null) {
            return null;
        }
        String trimmed = value.trim();
        return trimmed.isEmpty() ? null : trimmed;
    }

    private static String valueOrError(@Nullable String value) {
        return value != null ? value : "ERROR";
    }

    private static String booleanString(@Nullable String value) {
        if (value == null || value.isBlank()) {
            return "false";
        }
        return Boolean.toString(Boolean.parseBoolean(value));
    }
}

