/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.background.backgrounds.video.mcef;

import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.customization.background.MenuBackground;
import de.keksuccino.fancymenu.customization.background.MenuBackgroundBuilder;
import de.keksuccino.fancymenu.customization.background.backgrounds.video.IVideoMenuBackground;
import de.keksuccino.fancymenu.customization.element.elements.video.VideoElementController;
import de.keksuccino.fancymenu.customization.placeholder.PlaceholderParser;
import de.keksuccino.fancymenu.util.SerializationUtils;
import de.keksuccino.fancymenu.util.mcef.MCEFUtil;
import de.keksuccino.fancymenu.util.rendering.DrawableColor;
import de.keksuccino.fancymenu.util.rendering.video.mcef.MCEFVideoManager;
import de.keksuccino.fancymenu.util.rendering.video.mcef.MCEFVideoPlayer;
import de.keksuccino.fancymenu.util.resource.ResourceSource;
import java.awt.Color;
import java.io.File;
import java.util.Objects;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MCEFVideoMenuBackground
extends MenuBackground
implements IVideoMenuBackground {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ScheduledExecutorService EXECUTOR = Executors.newSingleThreadScheduledExecutor();
    private static final DrawableColor MISSING_MCEF_COLOR = DrawableColor.of(Color.RED);
    @Nullable
    public ResourceSource rawVideoUrlSource = null;
    public boolean loop = false;
    public float volume = 1.0f;
    @NotNull
    public class_3419 soundSource = class_3419.field_15250;
    public boolean parallaxEnabled = false;
    @NotNull
    public String parallaxIntensityString = "0.02";
    public float lastParallaxIntensity = -10000.0f;
    public boolean invertParallax = false;
    protected volatile boolean initialized = false;
    @Nullable
    protected MCEFVideoManager videoManager = null;
    protected MCEFVideoPlayer videoPlayer = null;
    protected String playerId = null;
    protected String lastFinalUrl = null;
    protected int lastAbsoluteWidth = -10000;
    protected int lastAbsoluteHeight = -10000;
    protected int lastAbsoluteX = -10000;
    protected int lastAbsoluteY = -10000;
    protected Boolean lastLoop = null;
    protected float cachedActualVolume = -10000.0f;
    protected float lastCachedActualVolume = -11000.0f;
    protected Boolean lastPausedState = null;
    protected volatile long lastRenderTickTime = -1L;
    protected boolean pausedBySystem = false;
    protected final AtomicReference<Float> cachedDuration = new AtomicReference<Float>(Float.valueOf(0.0f));
    protected final AtomicReference<Float> cachedPlayTime = new AtomicReference<Float>(Float.valueOf(0.0f));
    protected volatile ScheduledFuture<?> garbageChecker = EXECUTOR.scheduleAtFixedRate(() -> {
        if (this.initialized && this.lastRenderTickTime != -1L && this.lastRenderTickTime + 11000L < System.currentTimeMillis()) {
            this.resetBackground();
        }
    }, 0L, 100L, TimeUnit.MILLISECONDS);
    protected volatile ScheduledFuture<?> asyncTicker = EXECUTOR.scheduleAtFixedRate(() -> {
        if (this.initialized) {
            this.cachedDuration.set(Float.valueOf(this._getDuration()));
            this.cachedPlayTime.set(Float.valueOf(this._getPlayTime()));
        }
    }, 0L, 900L, TimeUnit.MILLISECONDS);

    public MCEFVideoMenuBackground(MenuBackgroundBuilder<MCEFVideoMenuBackground> builder) {
        super(builder);
        if (MCEFUtil.isMCEFLoaded() && MCEFUtil.MCEF_initialized) {
            this.videoManager = MCEFVideoManager.getInstance();
        }
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partial) {
        this.lastParallaxIntensity = SerializationUtils.deserializeNumber(Float.class, Float.valueOf(0.02f), PlaceholderParser.replacePlaceholders(this.parallaxIntensityString)).floatValue();
        if (!MCEFUtil.isMCEFLoaded() || !MCEFUtil.MCEF_initialized) {
            graphics.method_25294(0, 0, MCEFVideoMenuBackground.getScreenWidth(), MCEFVideoMenuBackground.getScreenHeight(), MISSING_MCEF_COLOR.getColorInt());
            graphics.method_25300(class_310.method_1551().field_1772, "\u00a7lMCEF IS NOT INSTALLED! PLEASE DOWNLOAD FROM CURSEFORGE!", MCEFVideoMenuBackground.getScreenWidth() / 2, MCEFVideoMenuBackground.getScreenHeight() / 2, -1);
            return;
        }
        this.lastRenderTickTime = System.currentTimeMillis();
        RenderSystem.enableBlend();
        float[] parallaxOffset = this.calculateParallaxOffset(mouseX, mouseY);
        int x = 0;
        int y = 0;
        int w = MCEFVideoMenuBackground.getScreenWidth();
        int h = MCEFVideoMenuBackground.getScreenHeight();
        if (this.parallaxEnabled) {
            w = (int)((float)MCEFVideoMenuBackground.getScreenWidth() * (1.0f + this.lastParallaxIntensity));
            h = (int)((float)MCEFVideoMenuBackground.getScreenHeight() * (1.0f + this.lastParallaxIntensity));
            x = -((w - MCEFVideoMenuBackground.getScreenWidth()) / 2) + (int)parallaxOffset[0];
            y = -((h - MCEFVideoMenuBackground.getScreenHeight()) / 2) + (int)parallaxOffset[1];
        }
        graphics.method_25294(x, y, x + w, y + h, DrawableColor.BLACK.getColorIntWithAlpha(this.opacity));
        if (!this.ensureVideoManagerReady()) {
            RenderSystem.disableBlend();
            return;
        }
        if (!this.initialized) {
            this.initialized = true;
            this.playerId = this.videoManager.createPlayer(x, y, w, h);
            if (this.playerId != null) {
                this.videoPlayer = this.videoManager.getPlayer(this.playerId);
                if (this.videoPlayer != null) {
                    this.videoPlayer.setFillScreen(true);
                }
            }
        }
        if (this.videoPlayer == null) {
            return;
        }
        this.updateVolume();
        if (this.lastCachedActualVolume == -11000.0f || this.cachedActualVolume != this.lastCachedActualVolume) {
            this.setVolume(this.volume, true);
        }
        this.lastCachedActualVolume = this.cachedActualVolume;
        if (this.lastLoop == null || !Objects.equals(this.loop, this.lastLoop)) {
            this.videoPlayer.setLooping(this.loop);
        }
        this.lastLoop = this.loop;
        if (this.lastAbsoluteX != x || this.lastAbsoluteY != y || this.lastAbsoluteWidth != w || this.lastAbsoluteHeight != h) {
            this.videoPlayer.setPosition(x, y);
            this.videoPlayer.setSize(w, h);
        }
        this.lastAbsoluteX = x;
        this.lastAbsoluteY = y;
        this.lastAbsoluteWidth = w;
        this.lastAbsoluteHeight = h;
        boolean pausedState = this._isPaused();
        String finalVideoUrl = null;
        if (this.rawVideoUrlSource != null) {
            finalVideoUrl = PlaceholderParser.replacePlaceholders(this.rawVideoUrlSource.getSourceWithoutPrefix());
        }
        boolean videoUrlChanged = !Objects.equals(finalVideoUrl, this.lastFinalUrl);
        this.lastFinalUrl = finalVideoUrl;
        if (videoUrlChanged && finalVideoUrl != null) {
            this.videoPlayer.stop();
            try {
                File videoFile = new File(finalVideoUrl);
                if (videoFile.exists()) {
                    String videoUri = videoFile.toURI().toString();
                    this.videoPlayer.loadVideo(videoUri);
                    if (!pausedState) {
                        this.videoPlayer.play();
                    }
                } else {
                    this.videoPlayer.loadVideo(finalVideoUrl);
                    if (!pausedState) {
                        this.videoPlayer.play();
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("[FANCYMENU] Error processing video URL", (Throwable)e);
            }
        }
        if (this.lastPausedState == null || !Objects.equals(pausedState, this.lastPausedState)) {
            if (pausedState) {
                this.videoPlayer.pause();
            } else {
                this.videoPlayer.play();
            }
        }
        this.lastPausedState = pausedState;
        RenderSystem.enableBlend();
        this.videoPlayer.setOpacity(this.opacity);
        if (finalVideoUrl != null) {
            this.videoPlayer.render(graphics, mouseX, mouseY, partial);
        }
        RenderSystem.disableBlend();
    }

    protected float[] calculateParallaxOffset(int mouseX, int mouseY) {
        if (!this.parallaxEnabled) {
            return new float[]{0.0f, 0.0f};
        }
        float mouseXPercent = 2.0f * (float)mouseX / (float)MCEFVideoMenuBackground.getScreenWidth() - 1.0f;
        float mouseYPercent = 2.0f * (float)mouseY / (float)MCEFVideoMenuBackground.getScreenHeight() - 1.0f;
        float directionMultiplier = this.invertParallax ? 1.0f : -1.0f;
        float xOffset = directionMultiplier * this.lastParallaxIntensity * mouseXPercent * (float)MCEFVideoMenuBackground.getScreenWidth() * 0.5f;
        float yOffset = directionMultiplier * this.lastParallaxIntensity * mouseYPercent * (float)MCEFVideoMenuBackground.getScreenHeight() * 0.5f;
        return new float[]{xOffset, yOffset};
    }

    @Override
    public void onOpenScreen() {
        super.onOpenScreen();
        if (this.initialized && this.videoPlayer != null && this.pausedBySystem) {
            this.pausedBySystem = false;
            this.videoPlayer.play();
        }
    }

    @Override
    public void onCloseScreen(@Nullable class_437 closedScreen, @Nullable class_437 newScreen) {
        super.onCloseScreen(closedScreen, newScreen);
        if (this.initialized && this.videoPlayer != null) {
            this.pausedBySystem = true;
            this.videoPlayer.pause();
        }
    }

    @Override
    public void onAfterEnable() {
        super.onAfterEnable();
        if (this.initialized && this.videoPlayer != null && this.pausedBySystem) {
            this.pausedBySystem = false;
            this.videoPlayer.play();
        }
    }

    @Override
    public void onDisableOrRemove() {
        super.onDisableOrRemove();
        if (this.initialized && this.videoPlayer != null) {
            this.pausedBySystem = true;
            this.videoPlayer.pause();
        }
    }

    protected void setVolume(float volume, boolean updatePlayer) {
        this.volume = volume = Math.max(0.0f, Math.min(1.0f, volume));
        if (this.videoPlayer != null) {
            float actualVolume = this.volume;
            float masterVolume = class_310.method_1551().field_1690.method_1630(class_3419.field_15250);
            float soundSourceVolume = class_310.method_1551().field_1690.method_1630(this.soundSource);
            if (this.soundSource != class_3419.field_15250) {
                soundSourceVolume *= masterVolume;
            }
            actualVolume *= soundSourceVolume;
            this.cachedActualVolume = actualVolume *= this.getControllerVolume();
            if (updatePlayer) {
                this.videoPlayer.setVolume(Math.min(1.0f, Math.max(0.0f, actualVolume)));
            }
        }
    }

    protected void updateVolume() {
        this.setVolume(this.volume, false);
    }

    public float getControllerVolume() {
        VideoElementController.VideoElementMeta meta;
        if (!VideoElementController.hasMetaFor(this.getInstanceIdentifier())) {
            VideoElementController.putMeta(this.getInstanceIdentifier(), new VideoElementController.VideoElementMeta(this.getInstanceIdentifier(), 1.0f, false));
        }
        if ((meta = VideoElementController.getMeta(this.getInstanceIdentifier())) != null) {
            return Math.max(0.0f, Math.min(1.0f, meta.volume));
        }
        return 1.0f;
    }

    public boolean getControllerPausedState() {
        VideoElementController.VideoElementMeta meta;
        if (!VideoElementController.hasMetaFor(this.getInstanceIdentifier())) {
            VideoElementController.putMeta(this.getInstanceIdentifier(), new VideoElementController.VideoElementMeta(this.getInstanceIdentifier(), 1.0f, false));
        }
        if ((meta = VideoElementController.getMeta(this.getInstanceIdentifier())) == null) {
            return false;
        }
        return meta.paused;
    }

    public void disposePlayer() {
        if (this.videoManager != null && this.playerId != null && this.videoPlayer != null) {
            this.videoPlayer.stop();
            this.videoManager.removePlayer(this.playerId);
        }
    }

    public void resetBackground() {
        this.disposePlayer();
        this.initialized = false;
        this.videoPlayer = null;
        this.playerId = null;
        this.lastFinalUrl = null;
        this.lastAbsoluteWidth = -10000;
        this.lastAbsoluteHeight = -10000;
        this.lastAbsoluteX = -10000;
        this.lastAbsoluteY = -10000;
        this.lastLoop = null;
        this.cachedActualVolume = -10000.0f;
        this.lastCachedActualVolume = -11000.0f;
        this.lastPausedState = null;
        this.lastRenderTickTime = -1L;
        this.pausedBySystem = false;
    }

    protected float _getDuration() {
        if (!this.initialized || this.videoPlayer == null) {
            return 0.0f;
        }
        return (float)this.videoPlayer.getDuration();
    }

    protected float _getPlayTime() {
        if (!this.initialized || this.videoPlayer == null) {
            return 0.0f;
        }
        return (float)this.videoPlayer.getCurrentTime();
    }

    protected boolean _isPaused() {
        return this.getControllerPausedState() || this.pausedBySystem;
    }

    @Override
    public float getDuration() {
        return this.cachedDuration.get().floatValue();
    }

    @Override
    public float getPlayTime() {
        return this.cachedPlayTime.get().floatValue();
    }

    protected boolean ensureVideoManagerReady() {
        if (this.videoManager != null) {
            return true;
        }
        if (!MCEFUtil.isMCEFLoaded() || !MCEFUtil.MCEF_initialized) {
            return false;
        }
        if (!MCEFVideoManager.initialized) {
            return false;
        }
        this.videoManager = MCEFVideoManager.getInstance();
        return this.videoManager != null;
    }
}

