/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.customization.action.actions.animation;

import de.keksuccino.fancymenu.customization.action.Action;
import de.keksuccino.fancymenu.customization.element.AbstractElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerElement;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerHandler;
import de.keksuccino.fancymenu.customization.element.elements.animationcontroller.AnimationControllerStateController;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayer;
import de.keksuccino.fancymenu.customization.layer.ScreenCustomizationLayerHandler;
import de.keksuccino.fancymenu.util.LocalizationUtils;
import net.minecraft.class_2561;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToggleElementAnimatorAction
extends Action {
    private static final Logger LOGGER = LogManager.getLogger();

    public ToggleElementAnimatorAction() {
        super("toggle_element_animator");
    }

    @Override
    public boolean canRunAsync() {
        return false;
    }

    @Override
    public boolean hasValue() {
        return true;
    }

    @Override
    public void execute(@Nullable String value) {
        try {
            AbstractElement element;
            if (value == null || value.isEmpty()) {
                return;
            }
            AnimationControllerStateController.togglePlaying(value);
            ScreenCustomizationLayer layer = ScreenCustomizationLayerHandler.getActiveLayer();
            if (layer != null && (element = layer.getElementByInstanceIdentifier(value)) instanceof AnimationControllerElement) {
                AnimationControllerElement controller = (AnimationControllerElement)element;
                AnimationControllerHandler.resetController(controller);
            }
        }
        catch (Exception ex) {
            LOGGER.error("[FANCYMENU] Failed to execute ToggleElementAnimatorAction!", (Throwable)ex);
        }
    }

    @Override
    @NotNull
    public class_2561 getActionDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.toggle_element_animator");
    }

    @Override
    @NotNull
    public class_2561[] getActionDescription() {
        return LocalizationUtils.splitLocalizedLines("fancymenu.actions.toggle_element_animator.desc", new String[0]);
    }

    @Override
    public class_2561 getValueDisplayName() {
        return class_2561.method_43471((String)"fancymenu.actions.toggle_element_animator.value.desc");
    }

    @Override
    public String getValueExample() {
        return "element_animator_identifier";
    }
}

