/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.enhancedgroups;

import de.maxhenkel.admiral.permissions.PermissionManager;
import de.maxhenkel.enhancedgroups.EnhancedGroups;
import java.util.List;
import javax.annotation.Nullable;
import me.lucko.fabric.api.permissions.v0.Permissions;
import net.fabricmc.fabric.api.util.TriState;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_2168;
import net.minecraft.class_3222;

public class EnhancedGroupPermissionManager
implements PermissionManager<class_2168> {
    private final Permission AUTO_JOIN_GROUP_PERMISSION;
    private final Permission AUTO_JOIN_GROUP_GLOBAL_PERMISSION;
    private final Permission FORCE_JOIN_GROUP_PERMISSION;
    private final Permission INSTANT_GROUP_PERMISSION;
    private final Permission PERSISTENT_GROUP_PERMISSION;
    private final List<Permission> PERMISSIONS;
    private static Boolean loaded;

    public EnhancedGroupPermissionManager() {
        this.AUTO_JOIN_GROUP_PERMISSION = new Permission("enhancedgroups.autojoingroup", EnhancedGroups.CONFIG.autoJoinGroupCommandPermissionType.get());
        this.AUTO_JOIN_GROUP_GLOBAL_PERMISSION = new Permission("enhancedgroups.autojoingroup.global", EnhancedGroups.CONFIG.autoJoinGroupGlobalCommandPermissionType.get());
        this.FORCE_JOIN_GROUP_PERMISSION = new Permission("enhancedgroups.forcejoingroup", EnhancedGroups.CONFIG.forceJoinGroupCommandPermissionType.get());
        this.INSTANT_GROUP_PERMISSION = new Permission("enhancedgroups.instantgroup", EnhancedGroups.CONFIG.instantGroupCommandPermissionType.get());
        this.PERSISTENT_GROUP_PERMISSION = new Permission("enhancedgroups.persistentgroup", EnhancedGroups.CONFIG.persistentGroupCommandPermissionType.get());
        this.PERMISSIONS = List.of(this.AUTO_JOIN_GROUP_PERMISSION, this.AUTO_JOIN_GROUP_GLOBAL_PERMISSION, this.FORCE_JOIN_GROUP_PERMISSION, this.INSTANT_GROUP_PERMISSION, this.PERSISTENT_GROUP_PERMISSION);
    }

    public boolean hasPermission(class_2168 stack, String permission) {
        for (Permission p : this.PERMISSIONS) {
            if (!p.permission.equals(permission)) continue;
            if (stack.method_43737()) {
                return p.hasPermission(stack.method_44023());
            }
            if (p.getType().equals((Object)PermissionType.OPS)) {
                return stack.method_9259(2);
            }
            return p.hasPermission(null);
        }
        return false;
    }

    private static boolean isFabricPermissionsAPILoaded() {
        if (loaded == null && (loaded = Boolean.valueOf(FabricLoader.getInstance().isModLoaded("fabric-permissions-api-v0"))).booleanValue()) {
            EnhancedGroups.LOGGER.info("Using Fabric Permissions API");
        }
        return loaded;
    }

    private static class Permission {
        private final String permission;
        private final PermissionType type;

        public Permission(String permission, PermissionType type) {
            this.permission = permission;
            this.type = type;
        }

        public boolean hasPermission(@Nullable class_3222 player) {
            if (EnhancedGroupPermissionManager.isFabricPermissionsAPILoaded()) {
                return this.checkFabricPermission(player);
            }
            return this.type.hasPermission(player);
        }

        private boolean checkFabricPermission(@Nullable class_3222 player) {
            if (player == null) {
                return false;
            }
            TriState permissionValue = Permissions.getPermissionValue((class_1297)player, (String)this.permission);
            return switch (permissionValue) {
                case TriState.DEFAULT -> this.type.hasPermission(player);
                case TriState.TRUE -> true;
                default -> false;
            };
        }

        public PermissionType getType() {
            return this.type;
        }
    }

    public static enum PermissionType {
        EVERYONE,
        NOONE,
        OPS;


        boolean hasPermission(@Nullable class_3222 player) {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> true;
                case 1 -> false;
                case 2 -> player != null && player.method_5687(player.field_13995.method_3798());
            };
        }
    }
}

