/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1867;
import net.minecraft.class_1869;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.player005.recipe_modification.api.RecipeFilter;
import net.player005.recipe_modification.serialization.RecipeModifierParsingException;

public abstract class RecipeFilterSerializer {
    private static final Map<String, Function<JsonObject, RecipeFilter>> deserializers = new HashMap<String, Function<JsonObject, RecipeFilter>>();
    private static final class_2960 CRAFTING_SHAPED = class_2960.method_60654((String)"crafting_shaped");
    private static final class_2960 CRAFTING_SHAPELESS = class_2960.method_60654((String)"crafting_shapeless");

    public static RecipeFilter fromJson(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return RecipeFilterSerializer.fromString(primitive.getAsString());
        }
        if (!json.isJsonObject()) {
            throw new RecipeModifierParsingException("Invalid recipe filter: expected an object");
        }
        JsonObject object = json.getAsJsonObject();
        String filterId = object.get("type").getAsString();
        if (!deserializers.containsKey(filterId)) {
            throw new RecipeModifierParsingException("Unknown recipe filter type: " + filterId);
        }
        return deserializers.get(filterId).apply(object);
    }

    private static RecipeFilter fromString(String string) {
        if (string.startsWith("!")) {
            return RecipeFilter.not(RecipeFilterSerializer.fromString(string.substring(1)));
        }
        if (string.startsWith("#")) {
            return RecipeFilter.resultItemIs((class_6862<class_1792>)class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)string.replace("#", ""))));
        }
        if (string.equals("*")) {
            return RecipeFilter.ALWAYS_APPLY;
        }
        if (!string.contains(":")) {
            return RecipeFilter.namespaceEquals(string);
        }
        class_2960 rl = class_2960.method_12829((String)string);
        if (rl == null) {
            throw new RecipeModifierParsingException("Invalid resource location in shorthand recipe filter: " + string);
        }
        if (class_7923.field_41178.method_10250(rl)) {
            return RecipeFilter.resultItemIs((class_1792)class_7923.field_41178.method_10223(rl));
        }
        return RecipeFilter.idEquals(class_2960.method_60654((String)string));
    }

    private static RecipeFilter createFilterByResultItem(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            class_1792[] items = (class_1792[])array.asList().stream().map(jsonElement -> (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)jsonElement.getAsString()))).toArray(class_1792[]::new);
            return RecipeFilter.resultItemIs(items);
        }
        if (!(json instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)json).isString()) {
            throw new RecipeModifierParsingException("invalid result item recipe filter: must be either string or array of strings: " + String.valueOf(json));
        }
        String str = json.getAsString();
        if (str.startsWith("#")) {
            class_6862 itemTag = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60654((String)str.replace("#", "")));
            return RecipeFilter.resultItemIs((class_6862<class_1792>)itemTag);
        }
        class_1792 item = (class_1792)class_7923.field_41178.method_10223(class_2960.method_60654((String)str));
        return RecipeFilter.resultItemIs(item);
    }

    public static void registerSerializer(String name, Function<JsonObject, RecipeFilter> deserializer) {
        deserializers.put(name, deserializer);
    }

    static {
        RecipeFilterSerializer.registerSerializer("all_recipes", json -> RecipeFilter.ALWAYS_APPLY);
        RecipeFilterSerializer.registerSerializer("accepting_ingredient", json -> {
            class_1799 item = (class_1799)class_1799.field_24671.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("item")).getOrThrow();
            return RecipeFilter.acceptsIngredient(item);
        });
        RecipeFilterSerializer.registerSerializer("result_item_is", json -> {
            if (json.has("items")) {
                return RecipeFilterSerializer.createFilterByResultItem(json.get("items"));
            }
            if (json.has("item")) {
                return RecipeFilterSerializer.createFilterByResultItem(json.get("item"));
            }
            throw new RecipeModifierParsingException("'result_item_is' filter has no 'items' or 'item' defined - typo?");
        });
        RecipeFilterSerializer.registerSerializer("result_item_predicate", json -> {
            RecipeFilter itemFilter = null;
            if ((json = json.get("predicate").getAsJsonObject()).has("items")) {
                itemFilter = RecipeFilterSerializer.createFilterByResultItem(json.remove("items"));
            }
            class_2073 predicate = (class_2073)class_2073.field_45754.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
            return itemFilter == null ? RecipeFilter.resultItemMatches(predicate) : RecipeFilter.and(itemFilter, RecipeFilter.resultItemMatches(predicate));
        });
        RecipeFilterSerializer.registerSerializer("id_equals", json -> {
            class_2960 id = class_2960.method_60654((String)json.get("id").getAsString());
            return RecipeFilter.idEquals(id);
        });
        RecipeFilterSerializer.registerSerializer("namespace_equals", json -> {
            String namespace = json.get("namespace").getAsString();
            return RecipeFilter.namespaceEquals(namespace);
        });
        RecipeFilterSerializer.registerSerializer("and", json -> {
            JsonArray jsonFilters = json.getAsJsonArray("filters");
            ArrayList<RecipeFilter> filters = new ArrayList<RecipeFilter>();
            for (JsonElement filter : jsonFilters) {
                filters.add(RecipeFilterSerializer.fromJson(filter));
            }
            return RecipeFilter.and((RecipeFilter[])filters.toArray(RecipeFilter[]::new));
        });
        RecipeFilterSerializer.registerSerializer("or", json -> {
            JsonArray jsonFilters = json.getAsJsonArray("filters");
            ArrayList<RecipeFilter> filters = new ArrayList<RecipeFilter>();
            for (JsonElement filter : jsonFilters) {
                filters.add(RecipeFilterSerializer.fromJson(filter));
            }
            return RecipeFilter.or((RecipeFilter[])filters.toArray(RecipeFilter[]::new));
        });
        RecipeFilterSerializer.registerSerializer("not", json -> {
            RecipeFilter filter = RecipeFilterSerializer.fromJson(json.get("filter"));
            return RecipeFilter.not(filter);
        });
        RecipeFilterSerializer.registerSerializer("is_recipe_type", json -> {
            class_2960 rl = class_2960.method_60654((String)json.get("recipe_type").getAsString());
            if (rl.equals((Object)CRAFTING_SHAPED)) {
                return (recipe, registries) -> recipe.comp_1933() instanceof class_1869;
            }
            if (rl.equals((Object)CRAFTING_SHAPELESS)) {
                return (recipe, registries) -> recipe.comp_1933() instanceof class_1867;
            }
            class_3956 type = (class_3956)class_7923.field_41188.method_10223(rl);
            if (type == null) {
                throw new RecipeModifierParsingException("Unknown recipe type: " + String.valueOf(rl));
            }
            return RecipeFilter.isType(type);
        });
    }
}

