/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_6862;
import net.player005.recipe_modification.api.IngredientSelector;
import net.player005.recipe_modification.api.RecipeHelper;
import net.player005.recipe_modification.api.RecipeModification;

@FunctionalInterface
public interface RecipeModifier {
    public void apply(class_1860<?> var1, RecipeHelper var2);

    public static RecipeModifier removeAllIngredients(class_1792 item) {
        return RecipeModifier.removeIngredients(IngredientSelector.byItem(item));
    }

    public static RecipeModifier removeIngredients(IngredientSelector selector) {
        return (recipe, helper) -> {
            for (class_1856 ingredient : selector.selectIngredients(recipe, helper)) {
                recipe.method_8117().remove((Object)ingredient);
            }
        };
    }

    public static RecipeModifier addIngredient(class_1856 ingredient) {
        return (recipe, helper) -> recipe.method_8117().add((Object)ingredient);
    }

    public static RecipeModifier addAlternative(class_1792 original, class_1792 alternative) {
        return (recipe, helper) -> {
            for (class_1856 ingredient : recipe.method_8117()) {
                if (!ingredient.method_8093(original.method_7854())) continue;
                helper.addAlternative(ingredient, alternative);
            }
        };
    }

    public static RecipeModifier addAlternative(class_1792 original, class_6862<class_1792> alternative) {
        return (recipe, helper) -> {
            for (class_1856 ingredient : recipe.method_8117()) {
                if (!ingredient.method_8093(original.method_7854())) continue;
                helper.addAlternative(ingredient, alternative);
            }
        };
    }

    public static RecipeModifier addAlternative(IngredientSelector selector, class_1856 alternative) {
        return (recipe, helper) -> {
            for (class_1856 ingredient : selector.selectIngredients(recipe, helper)) {
                helper.addAlternative(ingredient, alternative);
            }
        };
    }

    public static RecipeModifier replaceIngredient(IngredientSelector selector, class_1856 newIngredient) {
        return (recipe, helper) -> {
            class_1856[] ingredients;
            for (class_1856 ingredient : ingredients = selector.selectIngredients(recipe, helper)) {
                helper.replaceIngredient(ingredient, newIngredient);
            }
        };
    }

    public static RecipeModifier replaceResultItem(Function<class_1799, class_1799> modifier) {
        return (recipe, helper) -> RecipeModification.registerGlobalResultModifier((recipe1, result, recipeInput) -> {
            if (recipe1 == recipe) {
                return (class_1799)modifier.apply(result);
            }
            return result;
        });
    }

    public static RecipeModifier replaceResultItem(class_1799 newResult) {
        return (recipe, helper) -> RecipeModification.replaceResultItem(recipe, newResult);
    }

    public static RecipeModifier modifyResultItem(Consumer<class_1799> itemStackModifier) {
        return (recipe, helper) -> RecipeModification.modifyResultItemSimple(recipe, itemStackModifier);
    }
}

