/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9695;
import net.player005.recipe_modification.api.ModificationSet;
import net.player005.recipe_modification.api.Platform;
import net.player005.recipe_modification.api.RecipeFilter;
import net.player005.recipe_modification.api.RecipeHelper;
import net.player005.recipe_modification.api.RecipeModifier;
import net.player005.recipe_modification.api.RecipeModifierHolder;
import net.player005.recipe_modification.api.ResultItemModifier;
import net.player005.recipe_modification.impl.RecipeManagerAccessorTwo;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnknownNullability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RecipeModification {
    public static final String modID = "recipe_modification";
    static final Logger logger = LoggerFactory.getLogger(RecipeModification.class);
    private static Platform platform;
    private static final class_2371<Consumer<class_1863>> recipeManagerCallbacks;
    private static final class_2371<class_2960> toRemove;
    private static final class_2371<RecipeModifierHolder> modifiers;
    private static @UnknownNullability ImmutableList<RecipeModifierHolder> modifiersFromDatapack;
    public static final List<ResultItemModifier> resultModifiers;
    private static final Map<class_1860<?>, class_1799> resultItemOverrides;
    private static @UnknownNullability ImmutableMultimap<class_1792, class_8786<?>> recipesByResult;
    private static @UnknownNullability class_1863 recipeManager;

    public static void onRecipeInit(Consumer<class_1863> consumer) {
        recipeManagerCallbacks.add(consumer);
    }

    public static CompletableFuture<Void> forAllRecipesAsync(Consumer<class_8786<?>> recipeConsumer) {
        return CompletableFuture.runAsync(() -> recipeManager.method_8126().forEach(recipeConsumer));
    }

    public static void registerGlobalResultModifier(ResultItemModifier modifier) {
        resultModifiers.add(modifier);
    }

    public static void modifyResultItemSimple(class_1860<?> recipe, Consumer<class_1799> modifier) {
        class_1799 result = recipe.method_8110(RecipeModification.getRegistryAccess());
        modifier.accept(result);
        if (recipe.method_8110(RecipeModification.getRegistryAccess()) == result) {
            return;
        }
        RecipeModification.registerGlobalResultModifier((recipe1, result1, recipeInput) -> {
            if (recipe1 == recipe) {
                modifier.accept(result1);
            }
            return result1;
        });
    }

    public static void replaceResultItem(class_1860<?> recipe, class_1799 newResult) {
        resultItemOverrides.put(recipe, newResult);
    }

    public static @UnknownNullability class_8786<?> findRecipeHolder(class_1860<?> recipe) {
        for (class_8786 recipeHolder : RecipeModification.getRecipeManager().method_8126()) {
            if (!recipeHolder.comp_1933().equals(recipe)) continue;
            return recipeHolder;
        }
        return null;
    }

    public static @UnknownNullability class_2960 findRecipeID(class_1860<?> recipe) {
        for (class_8786 recipeHolder : RecipeModification.getRecipeManager().method_8126()) {
            if (!recipeHolder.comp_1933().equals(recipe)) continue;
            return recipeHolder.comp_1932();
        }
        return null;
    }

    public static void removeRecipe(class_8786<?> recipeHolder) {
        toRemove.add((Object)recipeHolder.comp_1932());
    }

    public static void removeRecipe(class_2960 id) {
        toRemove.add((Object)id);
    }

    public static void registerModifier(RecipeModifierHolder recipeModifier) {
        modifiers.add((Object)recipeModifier);
    }

    public static void registerModifier(class_2960 id, RecipeFilter filter, ModificationSet modifications) {
        RecipeModification.registerModifier(new RecipeModifierHolder(id, filter, modifications));
    }

    public static void registerModifier(class_2960 id, RecipeFilter filter, RecipeModifier ... modifications) {
        RecipeModification.registerModifier(new RecipeModifierHolder(id, filter, modifications));
    }

    public static class_8786<?> getByID(class_2960 id) {
        RecipeModification.checkInitialised("get recipe by ID");
        return RecipeModification.getPlatform().getRecipeByID(recipeManager, id);
    }

    @ApiStatus.Internal
    public static void initPlatform(Platform platform) {
        RecipeModification.platform = platform;
    }

    public static Platform getPlatform() {
        return platform;
    }

    public static @UnknownNullability class_1863 getRecipeManager() {
        return recipeManager;
    }

    public static class_7225.class_7874 getRegistryAccess() {
        RecipeModification.checkInitialised("get the RecipeManager's registry access");
        return RecipeModification.getPlatform().getRegistryAccess(RecipeModification.getRecipeManager());
    }

    public static ImmutableMultimap<class_1792, class_8786<?>> getRecipesByResult() {
        RecipeModification.checkInitialised("get recipes by result map");
        return recipesByResult;
    }

    public static ImmutableCollection<class_8786<?>> getRecipesByResult(class_1792 resultItem) {
        RecipeModification.checkInitialised("get recipe by result");
        return recipesByResult.get((Object)resultItem);
    }

    public static List<RecipeModifierHolder> getAllModifiers() {
        ArrayList<RecipeModifierHolder> fullList = new ArrayList<RecipeModifierHolder>(modifiers.size() + modifiersFromDatapack.size());
        fullList.addAll((Collection<RecipeModifierHolder>)modifiers);
        fullList.addAll((Collection<RecipeModifierHolder>)modifiersFromDatapack);
        return fullList;
    }

    public static class_1799 tryGetResult(class_8786<?> recipe, class_7225.class_7874 registryAccess) {
        try {
            return recipe.comp_1933().method_8110(registryAccess);
        }
        catch (Exception exception) {
            logger.warn("Failed to get result for recipe {}", (Object)recipe.comp_1932());
            logger.debug("Exception querying result:", (Throwable)exception);
            return class_1799.field_8037;
        }
    }

    public static boolean isInitialised() {
        return recipeManager != null;
    }

    private static void checkInitialised(String action) {
        if (!RecipeModification.isInitialised()) {
            throw new IllegalStateException("Can't " + action + " before recipes are initialised.Maybe you need to use RecipeModification#onRecipeInit() ?");
        }
    }

    @ApiStatus.Internal
    public static class_1799 getRecipeResult(class_1860<?> recipe, class_1799 currentResult, @Nullable class_9695 recipeInput) {
        currentResult = resultItemOverrides.getOrDefault(recipe, currentResult).method_7972();
        for (ResultItemModifier modifier : resultModifiers) {
            currentResult = modifier.getResultItem(recipe, currentResult, recipeInput);
        }
        return currentResult;
    }

    @ApiStatus.Internal
    public static void onRecipeManagerLoad(class_1863 recipeManager) {
        RecipeModification.recipeManager = recipeManager;
        if (modifiersFromDatapack == null) {
            throw new IllegalStateException("Recipes were loaded before recipe modifiers from datapacks");
        }
        RecipeModification.applyModifications();
    }

    @ApiStatus.Internal
    public static void updateJsonRecipeModifiers(ImmutableList<RecipeModifierHolder> modifiers) {
        modifiersFromDatapack = modifiers;
    }

    @ApiStatus.Internal
    private static void applyModifications() {
        Stopwatch timer = Stopwatch.createStarted();
        CompletableFuture<Void> recipeManagerMutable = CompletableFuture.runAsync(() -> ((RecipeManagerAccessorTwo)recipeManager).recipeModification$makeMutable());
        recipesByResult = RecipeModification.buildRecipeResultMap();
        logger.debug("Built recipe by result map for {} recipes in {}", (Object)recipeManager.method_8126().size(), (Object)timer);
        timer.reset().start();
        for (Consumer recipeManagerCallback : recipeManagerCallbacks) {
            recipeManagerCallback.accept(recipeManager);
        }
        logger.debug("Executed {} recipe manager callbacks in {}", (Object)recipeManagerCallbacks.size(), (Object)timer);
        timer.reset().start();
        int modified = 0;
        logger.info("Found {} recipe modifiers in datapacks, {} total", (Object)modifiersFromDatapack.size(), (Object)RecipeModification.getAllModifiers().size());
        class_7225.class_7874 registryAccess = RecipeModification.getRegistryAccess();
        for (class_8786 recipeHolder : recipeManager.method_8126()) {
            int appliedOnRecipe = RecipeModification.applyAllModifiers(recipeHolder, registryAccess);
            modified += appliedOnRecipe;
        }
        recipeManagerMutable.join();
        recipeManager.method_8126().removeIf(r -> toRemove.contains((Object)r.comp_1932()));
        recipeManager.method_59822().removeIf(r -> toRemove.contains((Object)r.comp_1932()));
        logger.info("Applied {} modifications to recipes in {}", (Object)modified, (Object)timer);
    }

    private static int applyAllModifiers(class_8786<?> recipeHolder, class_7225.class_7874 registryAccess) {
        int appliedOnRecipe = 0;
        for (RecipeModifierHolder modifier : RecipeModification.getAllModifiers()) {
            try {
                if (!modifier.filter().shouldApply(recipeHolder, registryAccess)) continue;
                RecipeHelper helper = RecipeModification.getPlatform().getHelper();
                modifier.apply(recipeHolder.comp_1933(), helper);
            }
            catch (Exception e) {
                RecipeModification.handleError(recipeHolder, modifier, e);
            }
            ++appliedOnRecipe;
        }
        return appliedOnRecipe;
    }

    private static ImmutableMultimap<class_1792, class_8786<?>> buildRecipeResultMap() {
        ImmutableMultimap.Builder byResultBuilder = ImmutableMultimap.builder();
        for (class_8786 recipeHolder : recipeManager.method_8126()) {
            class_1799 result = RecipeModification.tryGetResult(recipeHolder, RecipeModification.getRegistryAccess());
            if (result == null) continue;
            byResultBuilder.put((Object)result.method_7909(), (Object)recipeHolder);
        }
        return byResultBuilder.build();
    }

    private static void handleError(class_8786<?> recipe, RecipeModifierHolder modifier, Exception e) {
        logger.debug("Failed to apply modifier '{}' to recipe '{}'", (Object)modifier.id(), (Object)recipe.comp_1932());
        logger.debug("Exception:", (Throwable)e);
    }

    static {
        recipeManagerCallbacks = class_2371.method_10211();
        toRemove = class_2371.method_10211();
        modifiers = class_2371.method_10211();
        resultModifiers = class_2371.method_10211();
        resultItemOverrides = new IdentityHashMap();
    }
}

