/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2073;
import net.minecraft.class_2960;
import net.minecraft.class_3956;
import net.minecraft.class_6862;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.apache.commons.lang3.ArrayUtils;

public interface RecipeFilter {
    public static final RecipeFilter ALWAYS_APPLY = (recipe, registryAccess) -> true;

    public boolean shouldApply(class_8786<?> var1, class_7225.class_7874 var2);

    public static RecipeFilter acceptsIngredient(class_1799 item) {
        return (recipe, registryAccess) -> {
            for (class_1856 ingredient : recipe.comp_1933().method_8117()) {
                if (!ingredient.method_8093(item)) continue;
                return true;
            }
            return false;
        };
    }

    public static RecipeFilter resultItemIs(class_1792 item) {
        return (recipe, registryAccess) -> recipe.comp_1933().method_8110(registryAccess).method_31574(item);
    }

    public static RecipeFilter resultItemIs(class_1792[] items) {
        return (recipe, registryAccess) -> ArrayUtils.contains((Object[])items, (Object)recipe.comp_1933().method_8110(registryAccess));
    }

    public static RecipeFilter resultItemIs(class_6862<class_1792> itemTag) {
        return (recipe, registryAccess) -> recipe.comp_1933().method_8110(registryAccess).method_31573(itemTag);
    }

    public static RecipeFilter resultItemMatches(class_2073 predicate) {
        return (recipe, registryAccess) -> predicate.method_8970(recipe.comp_1933().method_8110(registryAccess));
    }

    public static RecipeFilter idEquals(class_2960 id) {
        return (recipe, registryAccess) -> recipe.comp_1932().equals((Object)id);
    }

    public static RecipeFilter namespaceEquals(String group) {
        return (recipe, registryAccess) -> recipe.comp_1932().method_12836().equals(group);
    }

    public static RecipeFilter isType(class_3956<?> recipeType) {
        return (recipe, registryAccess) -> recipe.comp_1933().method_17716().equals((Object)recipeType);
    }

    public static RecipeFilter and(RecipeFilter ... filters) {
        return (recipe, registryAccess) -> {
            for (RecipeFilter filter : filters) {
                if (filter.shouldApply(recipe, registryAccess)) continue;
                return false;
            }
            return true;
        };
    }

    public static RecipeFilter or(RecipeFilter ... filters) {
        return (recipe, registryAccess) -> {
            for (RecipeFilter filter : filters) {
                if (!filter.shouldApply(recipe, registryAccess)) continue;
                return true;
            }
            return false;
        };
    }

    public static RecipeFilter not(RecipeFilter filter) {
        return (recipe, registryAccess) -> !filter.shouldApply(recipe, registryAccess);
    }
}

