/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.util;

import java.util.regex.Pattern;
import org.commonmark.node.Block;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.ParserState;
import rearth.oracle.util.MdxComponentBlock;

public class MdxLeafParser
extends AbstractBlockParser {
    private final MdxComponentBlock block;
    private final StringBuilder content = new StringBuilder();
    private final Pattern endPattern;
    private final boolean finishedOnStart;

    public MdxLeafParser(MdxComponentBlock block, String tagName, String firstLine) {
        this.block = block;
        this.endPattern = Pattern.compile(".*(/>|</" + tagName + ">).*", 2);
        this.content.append(firstLine).append("\n");
        this.finishedOnStart = this.endPattern.matcher(firstLine).matches();
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        if (this.finishedOnStart) {
            return BlockContinue.none();
        }
        CharSequence line = state.getLine().getContent();
        this.content.append(line).append("\n");
        if (this.endPattern.matcher(line).matches()) {
            return BlockContinue.finished();
        }
        return BlockContinue.atIndex((int)state.getIndex());
    }

    public void closeBlock() {
        this.block.setupContent(this.content.toString());
    }
}

