/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.util;

import java.util.regex.Pattern;
import org.commonmark.node.Block;
import org.commonmark.parser.block.AbstractBlockParser;
import org.commonmark.parser.block.BlockContinue;
import org.commonmark.parser.block.ParserState;
import rearth.oracle.util.MdxComponentBlock;

public class MdxContainerParser
extends AbstractBlockParser {
    private final MdxComponentBlock block;
    private final Pattern endPattern;

    public MdxContainerParser(MdxComponentBlock block, String tagName, String firstLine) {
        this.block = block;
        this.endPattern = Pattern.compile(".*(</" + tagName + ">).*", 2);
        block.setupContent(firstLine);
    }

    public boolean isContainer() {
        return true;
    }

    public boolean canContain(Block childBlock) {
        return true;
    }

    public Block getBlock() {
        return this.block;
    }

    public BlockContinue tryContinue(ParserState state) {
        CharSequence line = state.getLine().getContent();
        if (this.endPattern.matcher(line).matches()) {
            return BlockContinue.finished();
        }
        return BlockContinue.atIndex((int)state.getIndex());
    }
}

