/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.util;

import org.commonmark.parser.block.AbstractBlockParserFactory;
import org.commonmark.parser.block.BlockParser;
import org.commonmark.parser.block.BlockStart;
import org.commonmark.parser.block.MatchedBlockParser;
import org.commonmark.parser.block.ParserState;
import rearth.oracle.util.MdxComponentBlock;
import rearth.oracle.util.MdxContainerParser;
import rearth.oracle.util.MdxLeafParser;

public class MdxBlockFactory
extends AbstractBlockParserFactory {
    public BlockStart tryStart(ParserState state, MatchedBlockParser matchedBlockParser) {
        String line = state.getLine().getContent().toString().trim();
        if (line.startsWith("<CraftingRecipe")) {
            return this.startLeaf(new MdxComponentBlock.CraftingRecipeBlock(), "CraftingRecipe", line, state);
        }
        if (line.startsWith("<ModAsset")) {
            return this.startLeaf(new MdxComponentBlock.AssetBlock(true), "ModAsset", line, state);
        }
        if (line.startsWith("<Asset")) {
            return this.startLeaf(new MdxComponentBlock.AssetBlock(false), "Asset", line, state);
        }
        if (line.startsWith("<PrefabObtaining")) {
            return this.startLeaf(new MdxComponentBlock.PrefabObtainingBlock(), "PrefabObtaining", line, state);
        }
        if (line.startsWith("<Callout")) {
            return this.startContainer(new MdxComponentBlock.CalloutBlock(), "Callout", line, state);
        }
        return BlockStart.none();
    }

    private BlockStart startLeaf(MdxComponentBlock block, String tagName, String line, ParserState state) {
        return BlockStart.of((BlockParser[])new BlockParser[]{new MdxLeafParser(block, tagName, line)}).atIndex(state.getLine().getContent().length());
    }

    private BlockStart startContainer(MdxComponentBlock block, String tagName, String line, ParserState state) {
        return BlockStart.of((BlockParser[])new BlockParser[]{new MdxContainerParser(block, tagName, line)}).atIndex(state.getLine().getContent().length());
    }
}

