/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle.test;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.commonmark.ext.front.matter.YamlFrontMatterBlock;
import org.commonmark.ext.front.matter.YamlFrontMatterExtension;
import org.commonmark.node.AbstractVisitor;
import org.commonmark.node.Block;
import org.commonmark.node.BlockQuote;
import org.commonmark.node.BulletList;
import org.commonmark.node.FencedCodeBlock;
import org.commonmark.node.Heading;
import org.commonmark.node.HtmlBlock;
import org.commonmark.node.ListBlock;
import org.commonmark.node.ListItem;
import org.commonmark.node.Node;
import org.commonmark.node.OrderedList;
import org.commonmark.node.Paragraph;
import org.commonmark.node.SoftLineBreak;
import org.commonmark.node.Text;
import org.commonmark.node.ThematicBreak;
import org.commonmark.node.Visitor;
import org.commonmark.parser.Parser;
import org.commonmark.parser.block.BlockParserFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.DisplayName;
import org.junit.jupiter.api.Test;
import rearth.oracle.util.MarkdownParser;
import rearth.oracle.util.MdxBlockFactory;
import rearth.oracle.util.MdxComponentBlock;

class MarkdownTests {
    private final Parser parser = Parser.builder().extensions(List.of(YamlFrontMatterExtension.create())).enabledBlockTypes(Set.of(Heading.class, HtmlBlock.class, ThematicBreak.class, FencedCodeBlock.class, BlockQuote.class, ListBlock.class)).customBlockParserFactory((BlockParserFactory)new MdxBlockFactory()).build();

    MarkdownTests() {
    }

    @Test
    @DisplayName(value="Frontmatter: Extraction logic")
    void testFrontMatter() {
        String md = "---\ntitle: Nickel\n---\nBody";
        Map<String, String> data = MarkdownParser.parseFrontmatter(md);
        Assertions.assertEquals((Object)"Nickel", (Object)data.get("title"));
    }

    @Test
    @DisplayName(value="MDX: Parse Crafting Recipe attributes")
    void testRecipeLogic() {
        String md = "<CraftingRecipe\n    slots={['iron', 'gold']}\n    result=\"diamond\"\n    count={2}\n/>\n";
        Node doc = this.parser.parse(md);
        Node firstChild = doc.getFirstChild();
        Assertions.assertInstanceOf(MdxComponentBlock.CraftingRecipeBlock.class, (Object)firstChild);
        MdxComponentBlock.CraftingRecipeBlock recipe = (MdxComponentBlock.CraftingRecipeBlock)firstChild;
        Assertions.assertEquals((Object)"diamond", (Object)recipe.result);
        Assertions.assertEquals((int)2, (int)recipe.count);
        Assertions.assertTrue((boolean)recipe.slots.contains("iron"));
    }

    @Test
    @DisplayName(value="MDX: Parse Callout variants")
    void testCalloutLogic() {
        String md = "<Callout variant=\"warning\">\nContent\n</Callout>\n";
        Node doc = this.parser.parse(md);
        Node firstChild = doc.getFirstChild();
        Assertions.assertInstanceOf(MdxComponentBlock.CalloutBlock.class, (Object)firstChild);
        MdxComponentBlock.CalloutBlock callout = (MdxComponentBlock.CalloutBlock)firstChild;
        Assertions.assertEquals((Object)"warning", (Object)callout.variant);
    }

    @Test
    @DisplayName(value="Lists: Verify nesting depth and numbering sequence logic")
    void testNestedListLogic() {
        String md = "1. First\n2. Second\n   * Sub A\n   * Sub B\n3. Third\n";
        Node document = this.parser.parse(md);
        final ArrayList results = new ArrayList();
        AbstractVisitor testVisitor = new AbstractVisitor(this){

            public void visit(ListItem listItem) {
                Block parent = listItem.getParent();
                int depth = 0;
                Block ancestor = parent;
                while (ancestor instanceof ListBlock || ancestor instanceof ListItem) {
                    if (ancestor instanceof ListBlock) {
                        ++depth;
                    }
                    ancestor = ancestor.getParent();
                }
                String label = "";
                if (parent instanceof BulletList) {
                    label = "\u2022";
                } else if (parent instanceof OrderedList) {
                    OrderedList orderedList = (OrderedList)parent;
                    int index = 1;
                    for (Node sibling = listItem.getPrevious(); sibling != null; sibling = sibling.getPrevious()) {
                        if (!(sibling instanceof ListItem)) continue;
                        ++index;
                    }
                    label = String.valueOf(orderedList.getStartNumber() + index - 1);
                }
                results.add(depth + ":" + label);
                this.visitChildren((Node)listItem);
            }
        };
        document.accept((Visitor)testVisitor);
        Assertions.assertEquals((int)5, (int)results.size());
        Assertions.assertEquals((Object)"1:1", results.get(0));
        Assertions.assertEquals((Object)"1:2", results.get(1));
        Assertions.assertEquals((Object)"2:\u2022", results.get(2));
        Assertions.assertEquals((Object)"2:\u2022", results.get(3));
        Assertions.assertEquals((Object)"1:3", results.get(4));
    }

    @Test
    @DisplayName(value="Utility: Image width conversion")
    void testWidthLogic() {
        Assertions.assertEquals((float)0.5f, (float)MarkdownParser.convertImageWidth("50%"));
        Assertions.assertEquals((float)0.256f, (float)MarkdownParser.convertImageWidth("{256}"));
    }

    @Test
    @DisplayName(value="Formatting: Soft line breaks should be converted to spaces")
    void testSoftLineBreaks() {
        String md = "Line One\nLine Two\n";
        final StringBuilder result = new StringBuilder();
        AbstractVisitor testVisitor = new AbstractVisitor(this){

            public void visit(Text text) {
                result.append(text.getLiteral());
            }

            public void visit(SoftLineBreak softLineBreak) {
                result.append(" ");
            }
        };
        Node document = this.parser.parse(md);
        document.accept((Visitor)testVisitor);
        Assertions.assertEquals((Object)"Line One Line Two", (Object)result.toString().trim());
    }

    @Test
    @DisplayName(value="Should parse a complex MDX document into the correct AST nodes")
    void testFullDocumentStructure() {
        String fullDoc = "---\ntitle: Deepslate Nickel\nicon: oritech:nickel_ore\n---\n\n# Nickel Mining\nNickel is found in **deepslate** layers.\n\n<Callout variant=\"info\">\nIt is best harvested with an Oritech Drill.\n</Callout>\n\n## Crafting\n<CraftingRecipe\n    slots={['a','b','c','d','e','f','g','h','i']}\n    result=\"oritech:nickel_block\"\n    count={1}\n/>\n\n* Use it for plating\n* Use it for magnets\n";
        Node document = this.parser.parse(fullDoc);
        Assertions.assertNotNull((Object)document);
        Assertions.assertNotNull((Object)document.getFirstChild());
        Node current = document.getFirstChild();
        Assertions.assertInstanceOf(YamlFrontMatterBlock.class, (Object)current, (String)"Frontmatter is the first block");
        current = current.getNext();
        Assertions.assertInstanceOf(Heading.class, (Object)current, (String)"First node should be a Heading");
        Assertions.assertEquals((int)1, (int)((Heading)current).getLevel());
        current = current.getNext();
        Assertions.assertInstanceOf(Paragraph.class, (Object)current, (String)"Second node should be a Paragraph");
        current = current.getNext();
        Assertions.assertInstanceOf(MdxComponentBlock.CalloutBlock.class, (Object)current, (String)"Third node should be a CalloutBlock");
        MdxComponentBlock.CalloutBlock callout = (MdxComponentBlock.CalloutBlock)current;
        Assertions.assertEquals((Object)"info", (Object)callout.variant);
        current = current.getNext();
        Assertions.assertInstanceOf(Heading.class, (Object)current, (String)"Fourth node should be a Heading level 2");
        Assertions.assertEquals((int)2, (int)((Heading)current).getLevel());
        current = current.getNext();
        Assertions.assertInstanceOf(MdxComponentBlock.CraftingRecipeBlock.class, (Object)current, (String)"Fifth node should be a RecipeBlock");
        MdxComponentBlock.CraftingRecipeBlock recipe = (MdxComponentBlock.CraftingRecipeBlock)current;
        Assertions.assertEquals((Object)"oritech:nickel_block", (Object)recipe.result);
        current = current.getNext();
        Assertions.assertInstanceOf(BulletList.class, (Object)current, (String)"Sixth node should be a BulletList");
    }
}

