/*
 * Decompiled with CFR 0.152.
 */
package rearth.oracle;

import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import io.wispforest.owo.ui.util.Delta;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3264;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3545;
import net.minecraft.class_4013;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import rearth.oracle.Oracle;
import rearth.oracle.SemanticSearch;
import rearth.oracle.progress.AdvancementProgressValidator;
import rearth.oracle.ui.OracleScreen;
import rearth.oracle.ui.SearchScreen;
import rearth.oracle.util.MarkdownParser;

public final class OracleClient {
    public static final String ROOT_DIR = "books";
    public static final class_304 ORACLE_WIKI = new class_304("key.oracle_index.open", 72, "key.categories.oracle");
    public static final class_304 ORACLE_SEARCH = new class_304("key.oracle_index.search", -1, "key.categories.oracle");
    public static final Set<String> LOADED_WIKIS = new HashSet<String>();
    public static final HashMap<class_2960, ItemArticleRef> ITEM_LINKS = new HashMap();
    public static final HashMap<String, class_3545<String, String>> UNLOCK_CRITERIONS = new HashMap();
    public static final HashMap<String, Set<String>> AVAILABLE_MODES = new HashMap();
    public static final HashMap<String, class_2960> CONTENT_ID_MAP = new HashMap();
    public static class_1799 tooltipStack;
    public static float openEntryProgress;
    private static SemanticSearch searchInstance;

    public static void init() {
        Oracle.LOGGER.info("Hello from the Oracle Wiki Client!");
        KeyMappingRegistry.register((class_304)ORACLE_WIKI);
        KeyMappingRegistry.register((class_304)ORACLE_SEARCH);
        AdvancementProgressValidator.register();
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (ORACLE_WIKI.method_1436()) {
                if (class_437.method_25441()) {
                    Oracle.LOGGER.info("Opening Oracle Search...");
                    client.method_1507((class_437)new SearchScreen(client.field_1755));
                    return;
                }
                Oracle.LOGGER.info("Opening Oracle Wiki...");
                client.method_1507((class_437)new OracleScreen(client.field_1755));
            }
            if (ORACLE_SEARCH.method_1436()) {
                Oracle.LOGGER.info("Opening Oracle Search...");
                client.method_1507((class_437)new SearchScreen(client.field_1755));
            }
        });
        ReloadListenerRegistry.register((class_3264)class_3264.field_14188, (class_3302)((class_4013)manager -> {
            Oracle.LOGGER.info("Indexing Oracle Wiki Resources...");
            OracleClient.findAllResourceEntries(manager);
        }));
        ClientTickEvent.CLIENT_POST.register(client -> {
            if (class_437.method_25443()) {
                return;
            }
            openEntryProgress += Delta.compute((float)openEntryProgress, (float)0.0f, (float)0.13f);
        });
    }

    public static void openScreen(@Nullable String wikiId, @Nullable class_2960 entryId, @Nullable class_437 parent) {
        if (wikiId != null) {
            OracleScreen.activeWiki = wikiId;
        }
        if (entryId != null) {
            OracleScreen.activeEntry = entryId;
        }
        class_310.method_1551().method_1507((class_437)new OracleScreen(parent));
    }

    private static void findAllResourceEntries(class_3300 manager) {
        Map resources = manager.method_14488(ROOT_DIR, path -> path.method_12832().endsWith(".mdx"));
        LOADED_WIKIS.clear();
        ITEM_LINKS.clear();
        UNLOCK_CRITERIONS.clear();
        CONTENT_ID_MAP.clear();
        AVAILABLE_MODES.clear();
        for (Map.Entry entry : resources.entrySet()) {
            class_2960 resourceId = (class_2960)entry.getKey();
            String path2 = resourceId.method_12832();
            String[] segments = path2.split("/");
            if (segments.length < 2) continue;
            String modId = segments[1];
            LOADED_WIKIS.add(modId);
            boolean isContent = path2.contains("/.content/");
            String mode = isContent ? "content" : "docs";
            AVAILABLE_MODES.computeIfAbsent(modId, k -> new HashSet()).add(mode);
            try {
                InputStream inputStream = ((class_3298)entry.getValue()).method_14482();
                try {
                    String unlockText;
                    String[] parts;
                    String fileContent = new String(inputStream.readAllBytes(), StandardCharsets.UTF_8);
                    Map<String, String> frontmatter = MarkdownParser.parseFrontmatter(fileContent);
                    if (isContent && frontmatter.containsKey("id")) {
                        String id = frontmatter.get("id").trim();
                        CONTENT_ID_MAP.put(id, resourceId);
                        String[] itemId = class_2960.method_60654((String)id);
                        String title = frontmatter.getOrDefault("title", "missing");
                        if (title.equals("missing") && class_7923.field_41178.method_10250((class_2960)itemId)) {
                            title = class_1074.method_4662((String)((class_1792)class_7923.field_41178.method_10223((class_2960)itemId)).method_7876(), (Object[])new Object[0]);
                        }
                        ITEM_LINKS.put((class_2960)itemId, new ItemArticleRef(resourceId, title, modId));
                    }
                    if (frontmatter.containsKey("related_items")) {
                        String baseString = frontmatter.get("related_items").replace("[", "").replace("]", "");
                        for (String itemString : baseString.split(", ")) {
                            class_2960 itemId = class_2960.method_60654((String)itemString.trim());
                            ITEM_LINKS.put(itemId, new ItemArticleRef(resourceId, frontmatter.getOrDefault("title", "missing"), modId));
                        }
                    }
                    if (!frontmatter.containsKey("unlock") || (parts = (unlockText = frontmatter.get("unlock")).split(":", 2)).length != 2) continue;
                    UNLOCK_CRITERIONS.put(path2, (class_3545<String, String>)new class_3545((Object)parts[0], (Object)parts[1]));
                }
                finally {
                    if (inputStream == null) continue;
                    inputStream.close();
                }
            }
            catch (IOException e) {
                Oracle.LOGGER.error("Unable to load book entry: {}", (Object)resourceId, (Object)e);
            }
        }
    }

    public static SemanticSearch getOrCreateSearch() {
        if (searchInstance == null) {
            searchInstance = new SemanticSearch();
        }
        return searchInstance;
    }

    public static String getActiveLangCode() {
        return class_310.method_1551().method_1526().method_4669();
    }

    public static Optional<class_2960> getTranslatedPath(class_2960 identifier, String wikiId) {
        class_2960 translatedPath;
        String languageCode = OracleClient.getActiveLangCode();
        class_3300 resourceManager = class_310.method_1551().method_1478();
        if (!languageCode.startsWith("en_") && resourceManager.method_14486(translatedPath = class_2960.method_60655((String)identifier.method_12836(), (String)identifier.method_12832().replace("books/" + wikiId, "books/" + wikiId + "/.translated/" + languageCode))).isPresent()) {
            return Optional.of(translatedPath);
        }
        return Optional.empty();
    }

    static {
        openEntryProgress = 0.0f;
    }

    public record ItemArticleRef(class_2960 linkTarget, String entryName, String wikiId) {
    }
}

