/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.immediatelyfast.feature.core;

import com.mojang.blaze3d.systems.RenderSystem;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ReferenceArrayList;
import it.unimi.dsi.fastutil.objects.ReferenceList;
import net.minecraft.class_9799;
import net.raphimc.immediatelyfast.ImmediatelyFast;

public class BufferAllocatorPool {
    private static final ReferenceList<Entry> FREE = new ReferenceArrayList();
    private static final ReferenceList<Entry> IN_USE = new ReferenceArrayList();
    private static final Reference2ObjectMap<class_9799, Entry> BUFFER_ALLOCATOR_MAPPING = new Reference2ObjectOpenHashMap();

    private BufferAllocatorPool() {
    }

    public static class_9799 borrowBufferAllocator() {
        Entry entry;
        RenderSystem.assertOnRenderThread();
        if (FREE.isEmpty()) {
            entry = new Entry(new class_9799(256));
        } else {
            entry = (Entry)FREE.removeFirst();
            if (entry.bufferAllocator.field_52082 == 0L) {
                BUFFER_ALLOCATOR_MAPPING.remove((Object)entry.bufferAllocator);
                entry = new Entry(new class_9799(256));
            }
        }
        IN_USE.add((Object)entry);
        BUFFER_ALLOCATOR_MAPPING.put((Object)entry.bufferAllocator, (Object)entry);
        entry.onBorrow();
        return entry.bufferAllocator;
    }

    public static void returnBufferAllocatorSafe(class_9799 bufferAllocator) {
        RenderSystem.assertOnRenderThread();
        Entry entry = (Entry)BUFFER_ALLOCATOR_MAPPING.get((Object)bufferAllocator);
        if (!IN_USE.remove((Object)entry)) {
            return;
        }
        entry.onReturn();
        FREE.addFirst((Object)entry);
    }

    public static int getSize() {
        return FREE.size() + IN_USE.size();
    }

    public static void onEndFrame() {
        if (!IN_USE.isEmpty()) {
            IN_USE.removeIf(entry -> {
                if (entry.inUseOverMultipleFrames) {
                    ImmediatelyFast.LOGGER.warn("!!! Possible memory leak detected!!! A BufferAllocator was not returned to the pool. This is not a bug in ImmediatelyFast.");
                    ImmediatelyFast.LOGGER.warn("Allocation stack trace:");
                    if (entry.allocationStackTrace != null) {
                        for (StackTraceElement element : entry.allocationStackTrace) {
                            ImmediatelyFast.LOGGER.warn("\tat {}", (Object)element.toString());
                        }
                    } else {
                        ImmediatelyFast.LOGGER.warn("\t<No stack trace available. Enable debug_only_detailed_memory_leak_detection in the config to get stack traces>");
                    }
                    return true;
                }
                return false;
            });
            for (Entry entry2 : IN_USE) {
                entry2.inUseOverMultipleFrames = true;
            }
        }
        FREE.removeIf(entry -> {
            if (entry.shouldBeClosed()) {
                entry.bufferAllocator.close();
                BUFFER_ALLOCATOR_MAPPING.remove((Object)entry.bufferAllocator);
                return true;
            }
            return false;
        });
    }

    private static class Entry {
        private final class_9799 bufferAllocator;
        private long lastAccessTime;
        private boolean inUseOverMultipleFrames;
        private StackTraceElement[] allocationStackTrace;

        public Entry(class_9799 bufferAllocator) {
            this.bufferAllocator = bufferAllocator;
            this.lastAccessTime = System.currentTimeMillis();
        }

        public boolean shouldBeClosed() {
            return System.currentTimeMillis() - this.lastAccessTime > 60000L;
        }

        public void onBorrow() {
            this.lastAccessTime = System.currentTimeMillis();
            if (ImmediatelyFast.config.debug_only_detailed_memory_leak_detection) {
                this.allocationStackTrace = Thread.currentThread().getStackTrace();
            }
        }

        public void onReturn() {
            this.bufferAllocator.method_60811();
            this.inUseOverMultipleFrames = false;
            this.allocationStackTrace = null;
        }
    }
}

