/*
 * Decompiled with CFR 0.152.
 */
package sh.sit.plp.kotlin_shadedx.datetime;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sh.sit.plp.kotlin_shaded.Metadata;
import sh.sit.plp.kotlin_shaded.jvm.internal.DefaultConstructorMarker;
import sh.sit.plp.kotlin_shaded.jvm.internal.Intrinsics;
import sh.sit.plp.kotlin_shaded.jvm.internal.SourceDebugExtension;
import sh.sit.plp.kotlin_shaded.time.DurationKt;
import sh.sit.plp.kotlin_shaded.time.DurationUnit;
import sh.sit.plp.kotlin_shadedx.datetime.internal.MathJvmKt;
import sh.sit.plp.kotlin_shadedx.datetime.serializers.DateBasedDateTimeUnitSerializer;
import sh.sit.plp.kotlin_shadedx.datetime.serializers.DateTimeUnitSerializer;
import sh.sit.plp.kotlin_shadedx.datetime.serializers.DayBasedDateTimeUnitSerializer;
import sh.sit.plp.kotlin_shadedx.datetime.serializers.MonthBasedDateTimeUnitSerializer;
import sh.sit.plp.kotlin_shadedx.datetime.serializers.TimeBasedDateTimeUnitSerializer;
import sh.sit.plp.kotlin_shadedx.serialization.KSerializer;
import sh.sit.plp.kotlin_shadedx.serialization.Serializable;

@Serializable(with=DateTimeUnitSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b7\u0018\u0000 \u00102\u00020\u0001:\u0005\f\r\u000e\u000f\u0010B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0005\u001a\u00020\u0006H\u00a6\u0002J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\bH\u0004J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\bH\u0004\u0082\u0001\u0002\u0011\u0012\u00a8\u0006\u0013"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit;", "", "<init>", "()V", "times", "scalar", "", "formatToString", "", "value", "unit", "", "TimeBased", "DateBased", "DayBased", "MonthBased", "Companion", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DateBased;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased;", "sh.sit.plp.kotlin_shadedx-datetime"})
public abstract class DateTimeUnit {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final TimeBased NANOSECOND = new TimeBased(1L);
    @NotNull
    private static final TimeBased MICROSECOND = NANOSECOND.times(1000);
    @NotNull
    private static final TimeBased MILLISECOND = MICROSECOND.times(1000);
    @NotNull
    private static final TimeBased SECOND = MILLISECOND.times(1000);
    @NotNull
    private static final TimeBased MINUTE = SECOND.times(60);
    @NotNull
    private static final TimeBased HOUR = MINUTE.times(60);
    @NotNull
    private static final DayBased DAY = new DayBased(1);
    @NotNull
    private static final DayBased WEEK = DAY.times(7);
    @NotNull
    private static final MonthBased MONTH = new MonthBased(1);
    @NotNull
    private static final MonthBased QUARTER = MONTH.times(3);
    @NotNull
    private static final MonthBased YEAR = MONTH.times(12);
    @NotNull
    private static final MonthBased CENTURY = YEAR.times(100);

    private DateTimeUnit() {
    }

    @NotNull
    public abstract DateTimeUnit times(int var1);

    @NotNull
    protected final String formatToString(int value, @NotNull String unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value == 1 ? unit : "" + value + '-' + unit;
    }

    @NotNull
    protected final String formatToString(long value, @NotNull String unit) {
        Intrinsics.checkNotNullParameter(unit, "unit");
        return value == 1L ? unit : "" + value + '-' + unit;
    }

    public /* synthetic */ DateTimeUnit(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\u0007R\u0011\u0010\n\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0011\u0010\f\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0011\u0010\u000e\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0011\u0010\u0010\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015R\u0011\u0010\u0018\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001d\u0010\u001bR\u0011\u0010\u001e\u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u001bR\u0011\u0010 \u001a\u00020\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u001b\u00a8\u0006%"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$Companion;", "", "<init>", "()V", "NANOSECOND", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased;", "getNANOSECOND", "()Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased;", "MICROSECOND", "getMICROSECOND", "MILLISECOND", "getMILLISECOND", "SECOND", "getSECOND", "MINUTE", "getMINUTE", "HOUR", "getHOUR", "DAY", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DayBased;", "getDAY", "()Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DayBased;", "WEEK", "getWEEK", "MONTH", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$MonthBased;", "getMONTH", "()Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$MonthBased;", "QUARTER", "getQUARTER", "YEAR", "getYEAR", "CENTURY", "getCENTURY", "serializer", "Lsh/sit/plp/kotlin_shadedx/serialization/KSerializer;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit;", "sh.sit.plp.kotlin_shadedx-datetime"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TimeBased getNANOSECOND() {
            return NANOSECOND;
        }

        @NotNull
        public final TimeBased getMICROSECOND() {
            return MICROSECOND;
        }

        @NotNull
        public final TimeBased getMILLISECOND() {
            return MILLISECOND;
        }

        @NotNull
        public final TimeBased getSECOND() {
            return SECOND;
        }

        @NotNull
        public final TimeBased getMINUTE() {
            return MINUTE;
        }

        @NotNull
        public final TimeBased getHOUR() {
            return HOUR;
        }

        @NotNull
        public final DayBased getDAY() {
            return DAY;
        }

        @NotNull
        public final DayBased getWEEK() {
            return WEEK;
        }

        @NotNull
        public final MonthBased getMONTH() {
            return MONTH;
        }

        @NotNull
        public final MonthBased getQUARTER() {
            return QUARTER;
        }

        @NotNull
        public final MonthBased getYEAR() {
            return YEAR;
        }

        @NotNull
        public final MonthBased getCENTURY() {
            return CENTURY;
        }

        @NotNull
        public final KSerializer<DateTimeUnit> serializer() {
            return DateTimeUnitSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Serializable(with=DateBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b7\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003Z>\b\u0007\u0010\u0004\"\u00020\u00052\u00020\u0005B0\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\b\u0012\"\b\t\u0012\u001e\b\u000bB\u001a\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\f\u0012\f\b\r\u0012\b\b\fJ\u0004\b\b(\u000eZ>\b\u0007\u0010\u000f\"\u00020\u00102\u00020\u0010B0\b\u0006\u0012\b\b\u0007\u0012\u0004\b\b(\u0011\u0012\"\b\t\u0012\u001e\b\u000bB\u001a\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0012\u0012\f\b\r\u0012\b\b\fJ\u0004\b\b(\u000e\u0082\u0001\u0002\u0005\u0010\u00a8\u0006\u0014"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DateBased;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit;", "<init>", "()V", "DayBased", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DayBased;", "Lsh/sit/plp/kotlin_shaded/Deprecated;", "message", "Use DateTimeUnit.DayBased", "replaceWith", "Lsh/sit/plp/kotlin_shaded/ReplaceWith;", "expression", "DateTimeUnit.DayBased", "imports", "sh.sit.plp.kotlin_shadedx.datetime.DateTimeUnit", "MonthBased", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$MonthBased;", "Use DateTimeUnit.MonthBased", "DateTimeUnit.MonthBased", "Companion", "sh.sit.plp.kotlin_shadedx-datetime"})
    public static abstract class DateBased
    extends DateTimeUnit {
        @NotNull
        public static final Companion Companion = new Companion(null);

        private DateBased() {
            super(null);
        }

        public /* synthetic */ DateBased(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DateBased$Companion;", "", "<init>", "()V", "serializer", "Lsh/sit/plp/kotlin_shadedx/serialization/KSerializer;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DateBased;", "sh.sit.plp.kotlin_shadedx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<DateBased> serializer() {
                return DateBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable(with=DayBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DayBased;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DateBased;", "days", "", "<init>", "(I)V", "getDays", "()I", "times", "scalar", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "sh.sit.plp.kotlin_shadedx-datetime"})
    @SourceDebugExtension(value={"SMAP\nDateTimeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUnit.kt\nkotlinx/datetime/DateTimeUnit$DayBased\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class DayBased
    extends DateBased {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int days;

        public DayBased(int days) {
            super(null);
            this.days = days;
            if (!(this.days > 0)) {
                boolean bl = false;
                String string = "Unit duration must be positive, but was " + this.days + " days.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final int getDays() {
            return this.days;
        }

        @Override
        @NotNull
        public DayBased times(int scalar) {
            return new DayBased(MathJvmKt.safeMultiply(this.days, scalar));
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof DayBased && this.days == ((DayBased)other).days;
        }

        public int hashCode() {
            return this.days ^ 0x10000;
        }

        @NotNull
        public String toString() {
            return this.days % 7 == 0 ? this.formatToString(this.days / 7, "WEEK") : this.formatToString(this.days, "DAY");
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DayBased$Companion;", "", "<init>", "()V", "serializer", "Lsh/sit/plp/kotlin_shadedx/serialization/KSerializer;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DayBased;", "sh.sit.plp.kotlin_shadedx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<DayBased> serializer() {
                return DayBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Serializable(with=MonthBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\b\u001a\u00020\u00002\u0006\u0010\t\u001a\u00020\u0003H\u0096\u0002J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0096\u0002J\b\u0010\u000e\u001a\u00020\u0003H\u0016J\b\u0010\u000f\u001a\u00020\u0010H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0012"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$MonthBased;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$DateBased;", "months", "", "<init>", "(I)V", "getMonths", "()I", "times", "scalar", "equals", "", "other", "", "hashCode", "toString", "", "Companion", "sh.sit.plp.kotlin_shadedx-datetime"})
    @SourceDebugExtension(value={"SMAP\nDateTimeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUnit.kt\nkotlinx/datetime/DateTimeUnit$MonthBased\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class MonthBased
    extends DateBased {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int months;

        public MonthBased(int months) {
            super(null);
            this.months = months;
            if (!(this.months > 0)) {
                boolean bl = false;
                String string = "Unit duration must be positive, but was " + this.months + " months.";
                throw new IllegalArgumentException(string.toString());
            }
        }

        public final int getMonths() {
            return this.months;
        }

        @Override
        @NotNull
        public MonthBased times(int scalar) {
            return new MonthBased(MathJvmKt.safeMultiply(this.months, scalar));
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof MonthBased && this.months == ((MonthBased)other).months;
        }

        public int hashCode() {
            return this.months ^ 0x20000;
        }

        @NotNull
        public String toString() {
            return this.months % 1200 == 0 ? this.formatToString(this.months / 1200, "CENTURY") : (this.months % 12 == 0 ? this.formatToString(this.months / 12, "YEAR") : (this.months % 3 == 0 ? this.formatToString(this.months / 3, "QUARTER") : this.formatToString(this.months, "MONTH")));
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$MonthBased$Companion;", "", "<init>", "()V", "serializer", "Lsh/sit/plp/kotlin_shadedx/serialization/KSerializer;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$MonthBased;", "sh.sit.plp.kotlin_shadedx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<MonthBased> serializer() {
                return MonthBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Serializable(with=TimeBasedDateTimeUnitSerializer.class)
    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0004\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0011\u0010\u000b\u001a\u00020\u00002\u0006\u0010\f\u001a\u00020\rH\u0096\u0002J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0096\u0002J\b\u0010\u0015\u001a\u00020\rH\u0016J\b\u0010\u0016\u001a\u00020\tH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000e\u001a\u00020\u000f8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0007\u00a8\u0006\u0018"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit;", "nanoseconds", "", "<init>", "(J)V", "getNanoseconds", "()J", "unitName", "", "unitScale", "times", "scalar", "", "duration", "Lsh/sit/plp/kotlin_shaded/time/Duration;", "getDuration-UwyO8pc", "equals", "", "other", "", "hashCode", "toString", "Companion", "sh.sit.plp.kotlin_shadedx-datetime"})
    @SourceDebugExtension(value={"SMAP\nDateTimeUnit.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DateTimeUnit.kt\nkotlinx/datetime/DateTimeUnit$TimeBased\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,310:1\n1#2:311\n*E\n"})
    public static final class TimeBased
    extends DateTimeUnit {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long nanoseconds;
        @NotNull
        private final String unitName;
        private final long unitScale;

        public TimeBased(long nanoseconds) {
            super(null);
            this.nanoseconds = nanoseconds;
            if (!(this.nanoseconds > 0L)) {
                boolean bl = false;
                String string = "Unit duration must be positive, but was " + this.nanoseconds + " ns.";
                throw new IllegalArgumentException(string.toString());
            }
            if (this.nanoseconds % 3600000000000L == 0L) {
                this.unitName = "HOUR";
                this.unitScale = this.nanoseconds / 3600000000000L;
            } else if (this.nanoseconds % 60000000000L == 0L) {
                this.unitName = "MINUTE";
                this.unitScale = this.nanoseconds / 60000000000L;
            } else if (this.nanoseconds % (long)1000000000 == 0L) {
                this.unitName = "SECOND";
                this.unitScale = this.nanoseconds / (long)1000000000;
            } else if (this.nanoseconds % (long)1000000 == 0L) {
                this.unitName = "MILLISECOND";
                this.unitScale = this.nanoseconds / (long)1000000;
            } else if (this.nanoseconds % (long)1000 == 0L) {
                this.unitName = "MICROSECOND";
                this.unitScale = this.nanoseconds / (long)1000;
            } else {
                this.unitName = "NANOSECOND";
                this.unitScale = this.nanoseconds;
            }
        }

        public final long getNanoseconds() {
            return this.nanoseconds;
        }

        @Override
        @NotNull
        public TimeBased times(int scalar) {
            return new TimeBased(MathJvmKt.safeMultiply(this.nanoseconds, (long)scalar));
        }

        public final long getDuration-UwyO8pc() {
            return DurationKt.toDuration(this.nanoseconds, DurationUnit.NANOSECONDS);
        }

        public boolean equals(@Nullable Object other) {
            return this == other || other instanceof TimeBased && this.nanoseconds == ((TimeBased)other).nanoseconds;
        }

        public int hashCode() {
            return (int)this.nanoseconds ^ (int)(this.nanoseconds >> 32);
        }

        @NotNull
        public String toString() {
            return this.formatToString(this.unitScale, this.unitName);
        }

        @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a8\u0006\u0007"}, d2={"Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased$Companion;", "", "<init>", "()V", "serializer", "Lsh/sit/plp/kotlin_shadedx/serialization/KSerializer;", "Lsh/sit/plp/kotlin_shadedx/datetime/DateTimeUnit$TimeBased;", "sh.sit.plp.kotlin_shadedx-datetime"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final KSerializer<TimeBased> serializer() {
                return TimeBasedDateTimeUnitSerializer.INSTANCE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

