/*
 * Decompiled with CFR 0.152.
 */
package fabric.me.thosea.badoptimizations.config;

import fabric.me.thosea.badoptimizations.config.Config;
import fabric.me.thosea.badoptimizations.utils.PlatformMethods;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModIncompatibilities {
    public static final String KEY = "badoptimizations:incompatibilities";
    private final Map<String, List<IncompatibleMod>> incompats = new HashMap<String, List<IncompatibleMod>>();
    private boolean ignoreIncompatibilities;

    public ModIncompatibilities() {
        this.builtIn("enable_entity_renderer_caching", "twilightforest", "bedrockskinutility", "lazyyyyy");
        this.builtIn("enable_block_entity_renderer_caching", "lazyyyyy");
        this.builtIn("enable_sky_color_caching", "polytone");
        this.builtIn("enable_lightmap_caching", "polytone");
        this.builtIn("enable_entity_flag_caching", "biomeswevegone", "performant");
        this.builtIn("enable_remove_redundant_fov_calculations", "camera_lock_on");
        PlatformMethods.getModIncompatibilities().forEach((id, options) -> {
            IncompatibleMod mod = new IncompatibleMod(false, (String)id);
            options.forEach(option -> this.getList((String)option).add(mod));
        });
    }

    private void builtIn(String option, String ... mods) {
        for (String mod : mods) {
            if (!PlatformMethods.isModLoaded(mod)) continue;
            this.getList(option).add(new IncompatibleMod(true, mod));
        }
    }

    private List<IncompatibleMod> getList(String option) {
        return this.incompats.computeIfAbsent(option, k -> new ArrayList());
    }

    public void ignoreIncompatibilities() {
        this.ignoreIncompatibilities = true;
        Config.LOGGER.warn("Ignore incompatibilities is enabled!");
    }

    public boolean isIncompatible(String option) {
        if (this.ignoreIncompatibilities) {
            return false;
        }
        List<IncompatibleMod> list = this.incompats.get(option);
        if (list == null) {
            return false;
        }
        for (IncompatibleMod mod : list) {
            if (mod.builtIn) {
                Config.LOGGER.info("Disabling {} because mod \"{}\" is incompatible with it (built-in)", (Object)option, (Object)mod.mod);
                continue;
            }
            Config.LOGGER.info("Disabling {} because mod \"{}\" marks itself as incompatible with it (external)", (Object)option, (Object)mod.mod);
        }
        return true;
    }

    private record IncompatibleMod(boolean builtIn, String mod) {
    }
}

