/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util.block;

import com.google.common.collect.Sets;
import com.tacz.guns.config.common.AmmoConfig;
import com.tacz.guns.util.HitboxHelper;
import com.tacz.guns.util.block.BlockRayTrace;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.PrimedTnt;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.neoforged.neoforge.event.EventHooks;

public class ProjectileExplosion
extends Explosion {
    private static final ExplosionDamageCalculator DEFAULT_CONTEXT = new ExplosionDamageCalculator();
    private final Level level;
    private final double x;
    private final double y;
    private final double z;
    private final float power;
    private final float radius;
    private final boolean knockback;
    private final Entity owner;
    private final Entity exploder;
    private final ExplosionDamageCalculator damageCalculator;

    public ProjectileExplosion(Level level, Entity owner, Entity exploder, @Nullable DamageSource source, @Nullable ExplosionDamageCalculator damageCalculator, double x, double y, double z, float power, float radius, boolean knockback, Explosion.BlockInteraction mode) {
        super(level, exploder, source, damageCalculator, x, y, z, radius, ((Boolean)AmmoConfig.EXPLOSIVE_AMMO_FIRE.get()).booleanValue(), mode, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE);
        this.level = level;
        this.x = x;
        this.y = y;
        this.z = z;
        this.power = power;
        this.radius = radius;
        this.owner = owner;
        this.exploder = exploder;
        this.damageCalculator = damageCalculator == null ? DEFAULT_CONTEXT : damageCalculator;
        this.knockback = knockback;
    }

    public void explode() {
        this.level.gameEvent(this.exploder, (Holder)GameEvent.EXPLODE, BlockPos.containing((double)this.x, (double)this.y, (double)this.z));
        HashSet set = Sets.newHashSet();
        int i = 16;
        for (int x = 0; x < i; ++x) {
            for (int y = 0; y < i; ++y) {
                block2: for (int z = 0; z < i; ++z) {
                    if (x != 0 && x != i - 1 && y != 0 && y != i - 1 && z != 0 && z != i - 1) continue;
                    double d0 = (float)x / (float)(i - 1) * 2.0f - 1.0f;
                    double d1 = (float)y / (float)(i - 1) * 2.0f - 1.0f;
                    double d2 = (float)z / (float)(i - 1) * 2.0f - 1.0f;
                    double d3 = Math.sqrt(d0 * d0 + d1 * d1 + d2 * d2);
                    d0 /= d3;
                    d1 /= d3;
                    d2 /= d3;
                    double blockX = this.x;
                    double blockY = this.y;
                    double blockZ = this.z;
                    float f1 = 0.3f;
                    for (float f = this.radius * (0.7f + this.level.random.nextFloat() * 0.6f); f > 0.0f; f -= 0.22500001f) {
                        BlockPos pos = BlockPos.containing((double)blockX, (double)blockY, (double)blockZ);
                        BlockState blockState = this.level.getBlockState(pos);
                        FluidState fluidState = this.level.getFluidState(pos);
                        if (!this.level.isInWorldBounds(pos)) continue block2;
                        Optional optional = this.damageCalculator.getBlockExplosionResistance((Explosion)this, (BlockGetter)this.level, pos, blockState, fluidState);
                        if (optional.isPresent()) {
                            f -= (((Float)optional.get()).floatValue() + f1) * f1;
                        }
                        if (f > 0.0f && this.damageCalculator.shouldBlockExplode((Explosion)this, (BlockGetter)this.level, pos, blockState, f)) {
                            set.add(pos);
                        }
                        blockX += d0 * (double)f1;
                        blockY += d1 * (double)f1;
                        blockZ += d2 * (double)f1;
                    }
                }
            }
        }
        this.getToBlow().addAll(set);
        float radius = this.radius;
        int minX = Mth.floor((double)(this.x - (double)radius - 1.0));
        int maxX = Mth.floor((double)(this.x + (double)radius + 1.0));
        int minY = Mth.floor((double)(this.y - (double)radius - 1.0));
        int maxY = Mth.floor((double)(this.y + (double)radius + 1.0));
        int minZ = Mth.floor((double)(this.z - (double)radius - 1.0));
        int maxZ = Mth.floor((double)(this.z + (double)radius + 1.0));
        List entities = this.level.getEntities(this.exploder, new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ));
        EventHooks.onExplosionDetonate((Level)this.level, (Explosion)this, (List)entities, (double)(radius *= 2.0f));
        Vec3 explosionPos = new Vec3(this.x, this.y, this.z);
        for (Entity entity : entities) {
            Player player;
            double deltaZ;
            double deltaY;
            double deltaX;
            double strength;
            if (entity.ignoreExplosion((Explosion)this)) continue;
            AABB boundingBox = HitboxHelper.getFixedBoundingBox(entity, this.owner);
            double minDistance = radius;
            Vec3[] d = new Vec3[15];
            if (!(entity instanceof LivingEntity)) {
                strength = Math.sqrt(entity.distanceToSqr(explosionPos)) * 2.0 / (double)radius;
                deltaX = entity.getX() - this.x;
                deltaY = (entity instanceof PrimedTnt ? entity.getY() : entity.getEyeY()) - this.y;
                deltaZ = entity.getZ() - this.z;
            } else {
                deltaX = (boundingBox.maxX + boundingBox.minX) / 2.0;
                deltaY = (boundingBox.maxY + boundingBox.minY) / 2.0;
                deltaZ = (boundingBox.maxZ + boundingBox.minZ) / 2.0;
                d[0] = new Vec3(boundingBox.minX, boundingBox.minY, boundingBox.minZ);
                d[1] = new Vec3(boundingBox.minX, boundingBox.minY, boundingBox.maxZ);
                d[2] = new Vec3(boundingBox.minX, boundingBox.maxY, boundingBox.minZ);
                d[3] = new Vec3(boundingBox.maxX, boundingBox.minY, boundingBox.minZ);
                d[4] = new Vec3(boundingBox.minX, boundingBox.maxY, boundingBox.maxZ);
                d[5] = new Vec3(boundingBox.maxX, boundingBox.minY, boundingBox.maxZ);
                d[6] = new Vec3(boundingBox.maxX, boundingBox.maxY, boundingBox.minZ);
                d[7] = new Vec3(boundingBox.maxX, boundingBox.maxY, boundingBox.maxZ);
                d[8] = new Vec3(boundingBox.minX, deltaY, deltaZ);
                d[9] = new Vec3(boundingBox.maxX, deltaY, deltaZ);
                d[10] = new Vec3(deltaX, boundingBox.minY, deltaZ);
                d[11] = new Vec3(deltaX, boundingBox.maxY, deltaZ);
                d[12] = new Vec3(deltaX, deltaY, boundingBox.minZ);
                d[13] = new Vec3(deltaX, deltaY, boundingBox.maxZ);
                d[14] = new Vec3(deltaX, deltaY, deltaZ);
                for (int s = 0; s < 15; ++s) {
                    BlockHitResult result = BlockRayTrace.rayTraceBlocks(this.level, new ClipContext(explosionPos, d[s], ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.empty()));
                    minDistance = result.getType() != HitResult.Type.BLOCK ? Math.min(minDistance, explosionPos.distanceTo(d[s])) : minDistance;
                }
                strength = minDistance * 2.0 / (double)radius;
                deltaX -= this.x;
                deltaY -= this.y;
                deltaZ -= this.z;
            }
            if (strength > 1.0) continue;
            double distanceToExplosion = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ);
            if (distanceToExplosion != 0.0) {
                deltaX /= distanceToExplosion;
                deltaY /= distanceToExplosion;
                deltaZ /= distanceToExplosion;
            }
            double damage = 1.0 - strength;
            entity.hurt(this.damageSource, (float)damage * this.power);
            if (entity instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)entity;
                damage *= 1.0 - livingEntity.getAttributeValue(Attributes.EXPLOSION_KNOCKBACK_RESISTANCE);
            }
            float multiplier = this.power * radius / 500.0f;
            if (!((Boolean)AmmoConfig.EXPLOSIVE_AMMO_KNOCK_BACK.get()).booleanValue() || !this.knockback) continue;
            entity.setDeltaMovement(entity.getDeltaMovement().add(deltaX * damage * (double)multiplier, deltaY * damage * (double)multiplier, deltaZ * damage * (double)multiplier));
            if (!(entity instanceof Player) || (player = (Player)entity).isSpectator() || player.isCreative() && player.getAbilities().flying) continue;
            this.getHitPlayers().put(player, new Vec3(deltaX * damage * (double)multiplier, deltaY * damage * (double)multiplier, deltaZ * damage * (double)multiplier));
        }
    }
}

