/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.resource.CommonAssetsManager;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.resources.ResourceLocation;

public final class AllowAttachmentTagMatcher {
    private static final String TAG_PREFIX = "#";

    public static boolean match(ResourceLocation gunId, ResourceLocation attachmentId) {
        Set<String> allowAttachmentTags = CommonAssetsManager.get().getAllowAttachmentTags(gunId);
        if (allowAttachmentTags == null || allowAttachmentTags.isEmpty()) {
            return false;
        }
        AtomicBoolean searchSignal = new AtomicBoolean(false);
        AllowAttachmentTagMatcher.treeSearch(allowAttachmentTags, attachmentId, searchSignal);
        return searchSignal.get();
    }

    private static void treeSearch(Set<String> tags, ResourceLocation attachmentId, AtomicBoolean searchSignal) {
        for (String tag : tags) {
            if (tag.startsWith(TAG_PREFIX)) {
                ResourceLocation tagId = ResourceLocation.parse((String)tag.substring(TAG_PREFIX.length()));
                Set<String> attachmentTags = CommonAssetsManager.get().getAttachmentTags(tagId);
                if (attachmentTags == null || attachmentTags.isEmpty()) continue;
                AllowAttachmentTagMatcher.treeSearch(attachmentTags, attachmentId, searchSignal);
                continue;
            }
            ResourceLocation matchAttachmentId = ResourceLocation.parse((String)tag);
            if (!attachmentId.equals((Object)matchAttachmentId)) continue;
            searchSignal.set(true);
            return;
        }
    }
}

