/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tacz.guns.api.vmlib.LuaGunLogicConstant;
import com.tacz.guns.api.vmlib.LuaLibrary;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.init.ModRecipe;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageSyncGunPack;
import com.tacz.guns.resource.ICommonResourceProvider;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.manager.AttachmentDataManager;
import com.tacz.guns.resource.manager.AttachmentsTagManager;
import com.tacz.guns.resource.manager.CommonDataManager;
import com.tacz.guns.resource.manager.INetworkCacheReloadListener;
import com.tacz.guns.resource.manager.RecipeFilterManager;
import com.tacz.guns.resource.manager.ScriptManager;
import com.tacz.guns.resource.network.CommonNetworkCache;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.block.BlockData;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import com.tacz.guns.resource.serialize.CommonAmmoIndexSerializer;
import com.tacz.guns.resource.serialize.CommonAttachmentIndexSerializer;
import com.tacz.guns.resource.serialize.CommonBlockIndexSerializer;
import com.tacz.guns.resource.serialize.CommonGunIndexSerializer;
import com.tacz.guns.resource.serialize.DistanceDamagePairSerializer;
import com.tacz.guns.resource.serialize.GunSmithTableIngredientSerializer;
import com.tacz.guns.resource.serialize.GunSmithTableResultSerializer;
import com.tacz.guns.resource.serialize.IgniteSerializer;
import com.tacz.guns.resource.serialize.PairSerializer;
import com.tacz.guns.resource.serialize.Vec3Serializer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.FileToIdConverter;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.packs.repository.PackRepository;
import net.minecraft.server.packs.resources.PreparableReloadListener;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.phys.Vec3;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.AddReloadListenerEvent;
import net.neoforged.neoforge.event.OnDatapackSyncEvent;
import net.neoforged.neoforge.event.TagsUpdatedEvent;
import net.neoforged.neoforge.event.server.ServerStoppedEvent;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;

@EventBusSubscriber
public class CommonAssetsManager
implements ICommonResourceProvider {
    private static CommonAssetsManager INSTANCE;
    public static final Gson GSON;
    private final List<INetworkCacheReloadListener> listeners = new ArrayList<INetworkCacheReloadListener>();
    private CommonDataManager<GunData> gunData;
    private CommonDataManager<AttachmentData> attachmentData;
    private CommonDataManager<BlockData> blockData;
    private CommonDataManager<CommonAmmoIndex> ammoIndex;
    private CommonDataManager<CommonGunIndex> gunIndex;
    private CommonDataManager<CommonAttachmentIndex> attachmentIndex;
    private CommonDataManager<CommonBlockIndex> blockIndex;
    private RecipeFilterManager recipeFilterManager;
    private AttachmentsTagManager attachmentsTagManager;
    List<LuaLibrary> libList = List.of(new LuaGunLogicConstant());
    private final ScriptManager scriptManager = new ScriptManager(new FileToIdConverter("scripts", ".lua"), this.libList);
    public RecipeManager recipeManager;

    public void reloadAndRegister(Consumer<PreparableReloadListener> register) {
        this.gunData = this.register(new CommonDataManager<GunData>(DataType.GUN_DATA, GunData.class, GSON, "data/guns", "GunDataLoader"));
        this.attachmentData = this.register(new AttachmentDataManager());
        this.attachmentsTagManager = this.register(new AttachmentsTagManager());
        this.recipeFilterManager = this.register(new RecipeFilterManager());
        this.blockData = this.register(new CommonDataManager<BlockData>(DataType.BLOCK_DATA, BlockData.class, GSON, "data/blocks", "BlockDataLoader"));
        register.accept((PreparableReloadListener)this.scriptManager);
        this.ammoIndex = this.register(new CommonDataManager<CommonAmmoIndex>(DataType.AMMO_INDEX, CommonAmmoIndex.class, GSON, "index/ammo", "AmmoIndexLoader"));
        this.gunIndex = this.register(new CommonDataManager<CommonGunIndex>(DataType.GUN_INDEX, CommonGunIndex.class, GSON, "index/guns", "GunIndexLoader"));
        this.attachmentIndex = this.register(new CommonDataManager<CommonAttachmentIndex>(DataType.ATTACHMENT_INDEX, CommonAttachmentIndex.class, GSON, "index/attachments", "AttachmentIndexLoader"));
        this.blockIndex = this.register(new CommonDataManager<CommonBlockIndex>(DataType.BLOCK_INDEX, CommonBlockIndex.class, GSON, "index/blocks", "BlockIndexLoader"));
        this.listeners.forEach(register);
    }

    private <T extends INetworkCacheReloadListener> T register(T listener) {
        this.listeners.add(listener);
        return listener;
    }

    public Map<DataType, Map<ResourceLocation, String>> getNetworkCache() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (INetworkCacheReloadListener listener : this.listeners) {
            builder.put((Object)listener.getType(), listener.getNetworkCache());
        }
        return builder.build();
    }

    @Override
    @Nullable
    public GunData getGunData(ResourceLocation id) {
        return (GunData)this.gunData.getData(id);
    }

    @Override
    @Nullable
    public AttachmentData getAttachmentData(ResourceLocation id) {
        return (AttachmentData)this.attachmentData.getData(id);
    }

    @Override
    @Nullable
    public BlockData getBlockData(ResourceLocation id) {
        return (BlockData)this.blockData.getData(id);
    }

    @Override
    @Nullable
    public RecipeFilter getRecipeFilter(ResourceLocation id) {
        return this.recipeFilterManager.getFilter(id);
    }

    @Override
    @Nullable
    public CommonGunIndex getGunIndex(ResourceLocation gunId) {
        return (CommonGunIndex)this.gunIndex.getData(gunId);
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonGunIndex>> getAllGuns() {
        return this.gunIndex.getAllData().entrySet();
    }

    @Override
    @Nullable
    public CommonAmmoIndex getAmmoIndex(ResourceLocation ammoId) {
        return (CommonAmmoIndex)this.ammoIndex.getData(ammoId);
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonAmmoIndex>> getAllAmmos() {
        return this.ammoIndex.getAllData().entrySet();
    }

    @Override
    @Nullable
    public CommonAttachmentIndex getAttachmentIndex(ResourceLocation attachmentId) {
        return (CommonAttachmentIndex)this.attachmentIndex.getData(attachmentId);
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonAttachmentIndex>> getAllAttachments() {
        return this.attachmentIndex.getAllData().entrySet();
    }

    @Override
    public LuaTable getScript(ResourceLocation scriptId) {
        return this.scriptManager.getScript(scriptId);
    }

    @Override
    @Nullable
    public CommonBlockIndex getBlockIndex(ResourceLocation blockId) {
        return (CommonBlockIndex)this.blockIndex.getData(blockId);
    }

    @Override
    public Set<Map.Entry<ResourceLocation, CommonBlockIndex>> getAllBlocks() {
        return this.blockIndex.getAllData().entrySet();
    }

    @Override
    public Set<String> getAttachmentTags(ResourceLocation registryName) {
        return this.attachmentsTagManager.getAttachmentTags(registryName);
    }

    @Override
    public Set<String> getAllowAttachmentTags(ResourceLocation registryName) {
        return this.attachmentsTagManager.getAllowAttachmentTags(registryName);
    }

    @Nullable
    public static CommonAssetsManager getInstance() {
        return INSTANCE;
    }

    public static ICommonResourceProvider get() {
        return INSTANCE == null ? CommonNetworkCache.INSTANCE : INSTANCE;
    }

    @SubscribeEvent
    public static void onReload(AddReloadListenerEvent event) {
        CommonAssetsManager commonAssetsManager = new CommonAssetsManager();
        commonAssetsManager.reloadAndRegister(arg_0 -> ((AddReloadListenerEvent)event).addListener(arg_0));
        INSTANCE = commonAssetsManager;
        CommonAssetsManager.INSTANCE.recipeManager = event.getServerResources().getRecipeManager();
    }

    @SubscribeEvent
    public static void onReload(TagsUpdatedEvent event) {
        if (event.getUpdateCause() == TagsUpdatedEvent.UpdateCause.SERVER_DATA_LOAD && CommonAssetsManager.getInstance() != null && CommonAssetsManager.getInstance().recipeManager != null) {
            List<GunSmithTableRecipe> recipes = CommonAssetsManager.getInstance().recipeManager.getAllRecipesFor((RecipeType)ModRecipe.GUN_SMITH_TABLE_CRAFTING.get()).stream().map(RecipeHolder::value).toList();
            for (GunSmithTableRecipe recipe : recipes) {
                recipe.init((HolderLookup.Provider)event.getRegistryAccess());
            }
        }
    }

    @SubscribeEvent
    public static void onServerStopped(ServerStoppedEvent event) {
        INSTANCE = null;
    }

    @SubscribeEvent
    public static void OnDatapackSync(OnDatapackSyncEvent event) {
        if (CommonAssetsManager.getInstance() == null) {
            return;
        }
        ServerMessageSyncGunPack message = new ServerMessageSyncGunPack(CommonAssetsManager.getInstance().getNetworkCache());
        if (event.getPlayer() != null) {
            NetworkHandler.sendToClientPlayer(message, (Player)event.getPlayer());
        } else {
            event.getPlayerList().getPlayers().forEach(player -> NetworkHandler.sendToClientPlayer(message, (Player)player));
        }
    }

    public static void reloadAllPack() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            return;
        }
        PackRepository packrepository = server.getPackRepository();
        packrepository.reload();
        Collection collection = packrepository.getSelectedIds();
        server.reloadResources(collection);
    }

    static {
        GSON = new GsonBuilder().registerTypeAdapter(ResourceLocation.class, (Object)new ResourceLocation.Serializer()).registerTypeAdapter(Pair.class, (Object)new PairSerializer()).registerTypeAdapter(GunSmithTableIngredient.class, (Object)new GunSmithTableIngredientSerializer()).registerTypeAdapter(GunSmithTableResult.class, (Object)new GunSmithTableResultSerializer()).registerTypeAdapter(ExtraDamage.DistanceDamagePair.class, (Object)new DistanceDamagePairSerializer()).registerTypeAdapter(Vec3.class, (Object)new Vec3Serializer()).registerTypeAdapter(Ignite.class, (Object)new IgniteSerializer()).registerTypeAdapter(RecipeFilter.class, (Object)new RecipeFilter.Deserializer()).registerTypeAdapter(CommonGunIndex.class, (Object)new CommonGunIndexSerializer()).registerTypeAdapter(CommonAmmoIndex.class, (Object)new CommonAmmoIndexSerializer()).registerTypeAdapter(CommonAttachmentIndex.class, (Object)new CommonAttachmentIndexSerializer()).registerTypeAdapter(CommonBlockIndex.class, (Object)new CommonBlockIndexSerializer()).registerTypeAdapter(TabConfig.class, (Object)new TabConfig.Deserializer()).create();
    }
}

