/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.particles;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.init.ModParticles;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public class BulletHoleOption
implements ParticleOptions {
    public static final MapCodec<BulletHoleOption> CODEC = RecordCodecBuilder.mapCodec(builder -> builder.group((App)Codec.INT.fieldOf("dir").forGetter(option -> option.direction.ordinal()), (App)Codec.LONG.fieldOf("pos").forGetter(option -> option.pos.asLong()), (App)Codec.STRING.fieldOf("ammo_id").forGetter(option -> option.ammoId), (App)Codec.STRING.fieldOf("gun_id").forGetter(option -> option.gunId), (App)Codec.STRING.optionalFieldOf("gun_display_id", (Object)DefaultAssets.DEFAULT_GUN_DISPLAY_ID.toString()).forGetter(option -> option.gunDisplayId)).apply((Applicative)builder, BulletHoleOption::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, BulletHoleOption> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, option -> option.direction.ordinal(), (StreamCodec)ByteBufCodecs.VAR_LONG, option -> option.pos.asLong(), (StreamCodec)ByteBufCodecs.STRING_UTF8, BulletHoleOption::getAmmoId, (StreamCodec)ByteBufCodecs.STRING_UTF8, BulletHoleOption::getGunId, (StreamCodec)ByteBufCodecs.STRING_UTF8, BulletHoleOption::getGunDisplayId, BulletHoleOption::new);
    private final Direction direction;
    private final BlockPos pos;
    private final String ammoId;
    private final String gunId;
    private final String gunDisplayId;

    public BulletHoleOption(int dir, long pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = Direction.values()[dir];
        this.pos = BlockPos.of((long)pos);
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public BulletHoleOption(Direction dir, BlockPos pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = dir;
        this.pos = pos;
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public Direction getDirection() {
        return this.direction;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public String getAmmoId() {
        return this.ammoId;
    }

    public String getGunId() {
        return this.gunId;
    }

    public String getGunDisplayId() {
        return this.gunDisplayId;
    }

    public ParticleType<?> getType() {
        return (ParticleType)ModParticles.BULLET_HOLE.get();
    }
}

