/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ServerMessageLevelUp
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ServerMessageLevelUp> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"server_level_up"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerMessageLevelUp> STREAM_CODEC = StreamCodec.composite((StreamCodec)ItemStack.STREAM_CODEC, ServerMessageLevelUp::getGun, (StreamCodec)ByteBufCodecs.INT, ServerMessageLevelUp::getLevel, ServerMessageLevelUp::new);
    private final ItemStack gun;
    private final int level;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ServerMessageLevelUp(ItemStack gun, int level) {
        this.gun = gun;
        this.level = level;
    }

    public static void handle(ServerMessageLevelUp message, IPayloadContext context) {
        context.enqueueWork(() -> ServerMessageLevelUp.onLevelUp(message));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void onLevelUp(ServerMessageLevelUp message) {
        int level = message.getLevel();
        ItemStack gun = message.getGun();
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
    }

    public ItemStack getGun() {
        return this.gun;
    }

    public int getLevel() {
        return this.level;
    }
}

