/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.client.gui.GunSmithTableScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ServerMessageCraft
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ServerMessageCraft> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"server_craft"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ServerMessageCraft> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, message -> message.menuId, ServerMessageCraft::new);
    private final int menuId;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ServerMessageCraft(int menuId) {
        this.menuId = menuId;
    }

    public static void handle(ServerMessageCraft message, IPayloadContext context) {
        context.enqueueWork(() -> ServerMessageCraft.updateScreen(message.menuId));
    }

    @OnlyIn(value=Dist.CLIENT)
    private static void updateScreen(int containerId) {
        Screen screen;
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.containerMenu.containerId == containerId && (screen = Minecraft.getInstance().screen) instanceof GunSmithTableScreen) {
            GunSmithTableScreen screen2 = (GunSmithTableScreen)screen;
            screen2.updateIngredientCount();
        }
    }
}

