/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageRefreshRefitScreen;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientMessageRefitGun
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ClientMessageRefitGun> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"client_refit_gun"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientMessageRefitGun> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.INT, message -> message.attachmentSlotIndex, (StreamCodec)ByteBufCodecs.INT, message -> message.gunSlotIndex, (StreamCodec)ByteBufCodecs.fromCodec(AttachmentType.CODEC), message -> message.attachmentType, ClientMessageRefitGun::new);
    private final int attachmentSlotIndex;
    private final int gunSlotIndex;
    private final AttachmentType attachmentType;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ClientMessageRefitGun(int attachmentSlotIndex, int gunSlotIndex, AttachmentType attachmentType) {
        this.attachmentSlotIndex = attachmentSlotIndex;
        this.gunSlotIndex = gunSlotIndex;
        this.attachmentType = attachmentType;
    }

    public static void handle(ClientMessageRefitGun message, IPayloadContext context) {
        context.enqueueWork(() -> {
            ServerPlayer player = (ServerPlayer)context.player();
            Inventory inventory = player.getInventory();
            ItemStack attachmentItem = inventory.getItem(message.attachmentSlotIndex);
            ItemStack gunItem = inventory.getItem(message.gunSlotIndex);
            IGun iGun = IGun.getIGunOrNull(gunItem);
            if (iGun != null && iGun.allowAttachment(gunItem, attachmentItem)) {
                ItemStack oldAttachmentItem = iGun.getAttachment((HolderLookup.Provider)player.registryAccess(), gunItem, message.attachmentType);
                iGun.installAttachment((HolderLookup.Provider)player.registryAccess(), gunItem, attachmentItem);
                AttachmentPropertyManager.postChangeEvent((LivingEntity)player, gunItem);
                inventory.setItem(message.attachmentSlotIndex, oldAttachmentItem);
                if (message.attachmentType == AttachmentType.EXTENDED_MAG) {
                    iGun.dropAllAmmo((Player)player, gunItem);
                }
                player.inventoryMenu.broadcastChanges();
                NetworkHandler.sendToClientPlayer(ServerMessageRefreshRefitScreen.INSTANCE, (Player)player);
            }
        });
    }
}

