/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.network.message;

import com.tacz.guns.inventory.GunSmithTableMenu;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public class ClientMessageCraft
implements CustomPacketPayload {
    public static final CustomPacketPayload.Type<ClientMessageCraft> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"client_craft"));
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientMessageCraft> STREAM_CODEC = StreamCodec.composite((StreamCodec)ResourceLocation.STREAM_CODEC, message -> message.recipeId, (StreamCodec)ByteBufCodecs.INT, message -> message.menuId, ClientMessageCraft::new);
    private final ResourceLocation recipeId;
    private final int menuId;

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return TYPE;
    }

    public ClientMessageCraft(ResourceLocation recipeId, int menuId) {
        this.recipeId = recipeId;
        this.menuId = menuId;
    }

    public static void handle(ClientMessageCraft message, IPayloadContext context) {
        context.enqueueWork(() -> {
            AbstractContainerMenu patt0$temp;
            ServerPlayer entity = (ServerPlayer)context.player();
            if (entity.containerMenu.containerId == message.menuId && (patt0$temp = entity.containerMenu) instanceof GunSmithTableMenu) {
                GunSmithTableMenu menu = (GunSmithTableMenu)patt0$temp;
                menu.doCraft(message.recipeId, (Player)entity);
            }
        });
    }
}

