/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.event;

import com.tacz.guns.entity.sync.core.DataEntry;
import com.tacz.guns.entity.sync.core.DataHolder;
import com.tacz.guns.entity.sync.core.SyncedDataKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import com.tacz.guns.network.message.ServerMessageUpdateEntityData;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityJoinLevelEvent;
import net.neoforged.neoforge.event.entity.player.PlayerEvent;
import net.neoforged.neoforge.event.tick.ServerTickEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber
public final class SyncedEntityDataEvent {
    @SubscribeEvent
    public static void onStartTracking(PlayerEvent.StartTracking event) {
        if (!event.getEntity().level().isClientSide()) {
            Entity entity = event.getTarget();
            DataHolder holder = SyncedEntityData.instance().getDataHolder(entity);
            if (holder != null) {
                List<DataEntry<?, ?>> entries = holder.gatherAll();
                entries.removeIf(entry -> !entry.getKey().syncMode().isTracking());
                if (!entries.isEmpty()) {
                    PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new ServerMessageUpdateEntityData(entity.getId(), entries), (CustomPacketPayload[])new CustomPacketPayload[0]);
                }
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerJoinWorld(EntityJoinLevelEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof Player) {
            List<DataEntry<?, ?>> entries;
            DataHolder holder;
            Player player = (Player)entity;
            if (!event.getLevel().isClientSide() && (holder = SyncedEntityData.instance().getDataHolder((Entity)player)) != null && !(entries = holder.gatherAll()).isEmpty()) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)event.getEntity()), (CustomPacketPayload)new ServerMessageUpdateEntityData(player.getId(), entries), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
        }
    }

    @SubscribeEvent
    public static void onPlayerClone(PlayerEvent.Clone event) {
        Player original = event.getOriginal();
        DataHolder oldHolder = SyncedEntityData.instance().getDataHolder((Entity)original);
        if (oldHolder == null) {
            return;
        }
        Player player = event.getEntity();
        DataHolder newHolder = SyncedEntityData.instance().getDataHolder((Entity)player);
        if (newHolder == null) {
            return;
        }
        HashMap dataMap = new HashMap(oldHolder.dataMap);
        if (event.isWasDeath()) {
            dataMap.entrySet().removeIf(entry -> !((SyncedDataKey)entry.getKey()).persistent());
        }
        newHolder.dataMap = dataMap;
    }

    @SubscribeEvent
    public static void onServerTick(ServerTickEvent.Post event) {
        SyncedEntityData instance = SyncedEntityData.instance();
        if (!instance.isDirty()) {
            return;
        }
        List<Entity> dirtyEntities = instance.getDirtyEntities();
        if (dirtyEntities.isEmpty()) {
            instance.setDirty(false);
            return;
        }
        for (Entity entity : dirtyEntities) {
            List<DataEntry<?, ?>> trackingEntries;
            List<DataEntry<?, ?>> entries;
            DataHolder holder = instance.getDataHolder(entity);
            if (holder == null || !holder.isDirty() || (entries = holder.gatherDirty()).isEmpty()) continue;
            List<DataEntry<?, ?>> selfEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isSelf()).collect(Collectors.toList());
            if (!selfEntries.isEmpty() && entity instanceof ServerPlayer) {
                PacketDistributor.sendToPlayer((ServerPlayer)((ServerPlayer)entity), (CustomPacketPayload)new ServerMessageUpdateEntityData(entity.getId(), selfEntries), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            if (!(trackingEntries = entries.stream().filter(entry -> entry.getKey().syncMode().isTracking()).collect(Collectors.toList())).isEmpty()) {
                PacketDistributor.sendToPlayersTrackingEntity((Entity)entity, (CustomPacketPayload)new ServerMessageUpdateEntityData(entity.getId(), trackingEntries), (CustomPacketPayload[])new CustomPacketPayload[0]);
            }
            holder.clean();
        }
        dirtyEntities.clear();
        instance.setDirty(false);
    }
}

