/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.config.util;

import com.google.common.collect.Lists;
import com.tacz.guns.config.sync.SyncConfig;
import java.util.EnumMap;
import java.util.List;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.StringUtils;

public class InteractKeyConfigRead {
    private static final EnumMap<Type, List<ResourceLocation>> WHITELIST = new EnumMap(Type.class);
    private static final EnumMap<Type, List<ResourceLocation>> BLACKLIST = new EnumMap(Type.class);
    private static final TagKey<Block> WHITELIST_BLOCKS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"interact_key/whitelist"));
    private static final TagKey<Block> BLACKLIST_BLOCKS = BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"interact_key/blacklist"));
    private static final TagKey<EntityType<?>> WHITELIST_ENTITIES = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"interact_key/whitelist"));
    private static final TagKey<EntityType<?>> BLACKLIST_ENTITIES = TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"interact_key/blacklist"));

    public static void init() {
        WHITELIST.clear();
        BLACKLIST.clear();
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_WHITELIST_BLOCKS.get(), WHITELIST, Type.BLOCK);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_WHITELIST_ENTITIES.get(), WHITELIST, Type.ENTITY);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_BLACKLIST_BLOCKS.get(), BLACKLIST, Type.BLOCK);
        InteractKeyConfigRead.handleConfigData((List)SyncConfig.INTERACT_KEY_BLACKLIST_ENTITIES.get(), BLACKLIST, Type.ENTITY);
    }

    public static boolean canInteractBlock(BlockState block) {
        ResourceLocation blockId = BuiltInRegistries.BLOCK.getKey((Object)block.getBlock());
        if (BLACKLIST.containsKey((Object)Type.BLOCK) && BLACKLIST.get((Object)Type.BLOCK).contains(blockId)) {
            return false;
        }
        if (block.is(BLACKLIST_BLOCKS)) {
            return false;
        }
        if (WHITELIST.containsKey((Object)Type.BLOCK) && WHITELIST.get((Object)Type.BLOCK).contains(blockId)) {
            return true;
        }
        return block.is(WHITELIST_BLOCKS);
    }

    public static boolean canInteractEntity(Entity entity) {
        ResourceLocation entityId = BuiltInRegistries.ENTITY_TYPE.getKey((Object)entity.getType());
        if (BLACKLIST.containsKey((Object)Type.ENTITY) && BLACKLIST.get((Object)Type.ENTITY).contains(entityId)) {
            return false;
        }
        if (entity.getType().is(BLACKLIST_ENTITIES)) {
            return false;
        }
        if (WHITELIST.containsKey((Object)Type.ENTITY) && WHITELIST.get((Object)Type.ENTITY).contains(entityId)) {
            return true;
        }
        return entity.getType().is(WHITELIST_ENTITIES);
    }

    private static void handleConfigData(List<String> configData, EnumMap<Type, List<ResourceLocation>> storeList, Type type) {
        configData.forEach(data -> {
            if (data.isEmpty()) {
                return;
            }
            if (StringUtils.isBlank((CharSequence)data)) {
                return;
            }
            ResourceLocation id = ResourceLocation.parse((String)data);
            storeList.computeIfAbsent(type, t -> Lists.newArrayList()).add(id);
        });
    }

    public static enum Type {
        BLOCK,
        ENTITY;

    }
}

