/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.jei;

import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IBlock;
import com.tacz.guns.api.item.IGun;
import mezz.jei.api.ingredients.subtypes.ISubtypeInterpreter;
import mezz.jei.api.ingredients.subtypes.UidContext;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.Nullable;

public class GunModSubtype {
    public static ISubtypeInterpreter<ItemStack> getAmmoSubtype() {
        return new ISubtypeInterpreter<ItemStack>(){

            @Nullable
            public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
                return this.getLegacyStringSubtypeInfo(stack, uidContext);
            }

            public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
                Item item = stack.getItem();
                if (item instanceof IAmmo) {
                    IAmmo iAmmo = (IAmmo)item;
                    return iAmmo.getAmmoId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<ItemStack> getGunSubtype() {
        return new ISubtypeInterpreter<ItemStack>(){

            @Nullable
            public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
                return this.getLegacyStringSubtypeInfo(stack, uidContext);
            }

            public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
                Item item = stack.getItem();
                if (item instanceof IGun) {
                    IGun iGun = (IGun)item;
                    return iGun.getGunId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<ItemStack> getAttachmentSubtype() {
        return new ISubtypeInterpreter<ItemStack>(){

            @Nullable
            public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
                return this.getLegacyStringSubtypeInfo(stack, uidContext);
            }

            public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
                Item item = stack.getItem();
                if (item instanceof IAttachment) {
                    IAttachment iAttachment = (IAttachment)item;
                    return iAttachment.getAttachmentId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<ItemStack> getTableSubType() {
        return new ISubtypeInterpreter<ItemStack>(){

            @Nullable
            public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
                return this.getLegacyStringSubtypeInfo(stack, uidContext);
            }

            public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
                Item item = stack.getItem();
                if (item instanceof IBlock) {
                    IBlock iBlock = (IBlock)item;
                    return iBlock.getBlockId(stack).toString();
                }
                return "";
            }
        };
    }

    public static ISubtypeInterpreter<ItemStack> getAmmoBoxSubtype() {
        return new ISubtypeInterpreter<ItemStack>(){

            @Nullable
            public Object getSubtypeData(ItemStack stack, UidContext uidContext) {
                return this.getLegacyStringSubtypeInfo(stack, uidContext);
            }

            public String getLegacyStringSubtypeInfo(ItemStack stack, UidContext uidContext) {
                Item item = stack.getItem();
                if (item instanceof IAmmoBox) {
                    IAmmoBox iAmmoBox = (IAmmoBox)item;
                    if (iAmmoBox.isAllTypeCreative(stack)) {
                        return "all_type_creative";
                    }
                    if (iAmmoBox.isCreative(stack)) {
                        return "creative";
                    }
                    return String.format("level_%d", iAmmoBox.getAmmoLevel(stack));
                }
                return "";
            }
        };
    }
}

