/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.command.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.tacz.guns.config.sync.SyncConfig;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.neoforged.neoforge.server.command.EnumArgument;

public class ConfigCommand {
    private static final String CONFIG_NAME = "config";
    private static final String KEY = "key";
    private static final String ENABLE = "state";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder config = Commands.literal((String)CONFIG_NAME);
        RequiredArgumentBuilder configKey = Commands.argument((String)KEY, (ArgumentType)EnumArgument.enumArgument(ConfigKey.class));
        RequiredArgumentBuilder state = Commands.argument((String)ENABLE, (ArgumentType)BoolArgumentType.bool());
        return (LiteralArgumentBuilder)config.then(configKey.then(state.executes(ConfigCommand::setConfig)));
    }

    private static int setConfig(CommandContext<CommandSourceStack> context) {
        ConfigKey key = (ConfigKey)((Object)context.getArgument(KEY, ConfigKey.class));
        boolean state = BoolArgumentType.getBool(context, (String)ENABLE);
        if (key == null) {
            return 0;
        }
        switch (key.ordinal()) {
            case 0: {
                SyncConfig.ENABLE_TABLE_FILTER.set((Object)state);
                break;
            }
            case 1: {
                SyncConfig.SERVER_SHOOT_NETWORK_V.set((Object)state);
                break;
            }
            case 2: {
                SyncConfig.SERVER_SHOOT_COOLDOWN_V.set((Object)state);
            }
        }
        ((CommandSourceStack)context.getSource()).sendSystemMessage((Component)Component.translatable((String)(key.lang + "." + (state ? "enabled" : "disabled"))));
        return 1;
    }

    public static enum ConfigKey {
        defaultTableLimit("commands.tacz.config.default_table_limit"),
        serverShootNetworkCheck("commands.tacz.config.server_shoot_network_check"),
        serverShootCooldownCheck("commands.tacz.config.server_shoot_cooldown_check");

        public final String lang;

        private ConfigKey(String lang) {
            this.lang = lang;
        }
    }
}

