/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.command.sub;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.tacz.guns.api.item.IGun;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class AttachmentLockCommand {
    private static final String ATTACHMENT_LOCK_NAME = "attachment_lock";
    private static final String ENTITY = "target";
    private static final String GUN_ATTACHMENT_LOCK = "AttachmentLock";

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder attachmentLock = Commands.literal((String)ATTACHMENT_LOCK_NAME);
        RequiredArgumentBuilder entities = Commands.argument((String)ENTITY, (ArgumentType)EntityArgument.entities());
        RequiredArgumentBuilder locked = Commands.argument((String)GUN_ATTACHMENT_LOCK, (ArgumentType)BoolArgumentType.bool());
        attachmentLock.then(entities.then(locked.executes(AttachmentLockCommand::setAttachmentLock)));
        return attachmentLock;
    }

    private static int setAttachmentLock(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Collection entities = EntityArgument.getEntities(context, (String)ENTITY);
        int cnt = 0;
        boolean locked = BoolArgumentType.getBool(context, (String)GUN_ATTACHMENT_LOCK);
        for (Entity entity : entities) {
            LivingEntity living;
            ItemStack stack;
            Item item;
            if (!(entity instanceof LivingEntity) || !((item = (stack = (living = (LivingEntity)entity).getMainHandItem()).getItem()) instanceof IGun)) continue;
            IGun iGun = (IGun)item;
            iGun.setAttachmentLock(stack, locked);
            ++cnt;
        }
        return cnt;
    }
}

