/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.tooltip;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.inventory.tooltip.AttachmentItemTooltip;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class ClientAttachmentItemTooltip
implements ClientTooltipComponent {
    private static final Cache<ResourceLocation, List<ItemStack>> CACHE = CacheBuilder.newBuilder().expireAfterAccess(5L, TimeUnit.SECONDS).build();
    private final ResourceLocation attachmentId;
    private final List<Component> components = Lists.newArrayList();
    private final MutableComponent tips = Component.translatable((String)"tooltip.tacz.attachment.yaw.shift");
    private final MutableComponent support = Component.translatable((String)"tooltip.tacz.attachment.yaw.support");
    @Nullable
    private MutableComponent packInfo;
    private List<ItemStack> showGuns = Lists.newArrayList();
    private ItemStack attachment;

    public ClientAttachmentItemTooltip(AttachmentItemTooltip tooltip) {
        this.attachmentId = tooltip.getAttachmentId();
        this.attachment = tooltip.getAttachmentItem();
        this.addText(tooltip.getType());
        this.getShowGuns();
        this.addPackInfo();
    }

    private void addPackInfo() {
        PackInfo packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(this.attachmentId);
        if (packInfoObject != null) {
            this.packInfo = Component.translatable((String)packInfoObject.getName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC);
        }
    }

    private static List<ItemStack> getAllAllowGuns(List<ItemStack> output, ResourceLocation attachmentId) {
        ItemStack attachment = AttachmentItemBuilder.create().setId(attachmentId).build();
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            ResourceLocation gunId = (ResourceLocation)entry.getKey();
            ItemStack gun = GunItemBuilder.create().setId(gunId).build((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess());
            Item patt0$temp = gun.getItem();
            if (!(patt0$temp instanceof IGun)) {
                return;
            }
            IGun iGun = (IGun)patt0$temp;
            if (iGun.allowAttachment(gun, attachment)) {
                output.add(gun);
            }
        });
        return output;
    }

    public int getHeight() {
        if (!Screen.hasShiftDown()) {
            return this.components.size() * 10 + 28;
        }
        return (this.showGuns.size() - 1) / 16 * 18 + 50 + this.components.size() * 10;
    }

    public int getWidth(Font font) {
        int[] width = new int[]{0};
        if (this.packInfo != null) {
            width[0] = Math.max(width[0], font.width((FormattedText)this.packInfo) + 4);
        }
        this.components.forEach(c -> {
            width[0] = Math.max(width[0], font.width((FormattedText)c));
        });
        if (!Screen.hasShiftDown()) {
            return Math.max(width[0], font.width((FormattedText)this.tips) + 4);
        }
        width[0] = Math.max(width[0], font.width((FormattedText)this.support) + 4);
        if (this.showGuns.size() > 15) {
            return Math.max(width[0], 260);
        }
        return Math.max(width[0], this.showGuns.size() * 16 + 4);
    }

    public void renderText(Font font, int pX, int pY, Matrix4f matrix4f, MultiBufferSource.BufferSource bufferSource) {
        int yOffset = pY;
        for (Component component : this.components) {
            font.drawInBatch(component, (float)pX, (float)yOffset, 0xFFAA00, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 10;
        }
        if (!Screen.hasShiftDown()) {
            font.drawInBatch((Component)this.tips, (float)pX, (float)(pY + 5 + this.components.size() * 10), 0x9E9E9E, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
            yOffset += 10;
        } else {
            yOffset += (this.showGuns.size() - 1) / 16 * 18 + 32;
        }
        if (this.packInfo != null) {
            font.drawInBatch((Component)this.packInfo, (float)pX, (float)(yOffset + 8), 0xFFFFFF, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        }
    }

    public void renderImage(Font font, int mouseX, int mouseY, GuiGraphics gui) {
        if (!Screen.hasShiftDown()) {
            return;
        }
        int minY = this.components.size() * 10 + 3;
        int maxX = this.getWidth(font);
        gui.fill(mouseX, mouseY + minY, mouseX + maxX, mouseY + minY + 11, -1895780097);
        gui.drawString(font, (Component)this.support, mouseX + 2, mouseY + minY + 2, 14938877);
        for (int i = 0; i < this.showGuns.size(); ++i) {
            ItemStack stack = this.showGuns.get(i);
            int x = i % 16 * 16 + 2;
            int y = i / 16 * 18 + minY + 15;
            gui.renderItem(stack, mouseX + x, mouseY + y);
        }
    }

    private void getShowGuns() {
        try {
            this.showGuns = (List)CACHE.get((Object)this.attachmentId, () -> ClientAttachmentItemTooltip.getAllAllowGuns(Lists.newArrayList(), this.attachmentId));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
    }

    public static String rgbToHex(int rgb) {
        int r = rgb >> 16 & 0xFF;
        int g = rgb >> 8 & 0xFF;
        int b = rgb & 0xFF;
        return String.format("#%02X%02X%02X", r, g, b);
    }

    private void addText(AttachmentType type) {
        TimelessAPI.getClientAttachmentIndex(this.attachmentId).ifPresent(index -> {
            float[] zoom;
            Item patt0$temp;
            AttachmentData data = index.getData();
            @Nullable String tooltipKey = index.getTooltipKey();
            if (tooltipKey != null) {
                String text = I18n.get((String)tooltipKey, (Object[])new Object[0]);
                String[] split = text.split("\n");
                Arrays.stream(split).forEach(s -> this.components.add((Component)Component.literal((String)s).withStyle(ChatFormatting.GRAY)));
            }
            if ((patt0$temp = this.attachment.getItem()) instanceof IAttachment) {
                IAttachment iAttachment = (IAttachment)patt0$temp;
                TimelessAPI.getClientAttachmentIndex(this.attachmentId).ifPresent(attachmentIndex -> {
                    if (iAttachment.hasCustomLaserColor(this.attachment)) {
                        int color = iAttachment.getLaserColor(this.attachment);
                        this.components.add((Component)Component.translatable((String)"tooltip.tacz.attachment.laser.color", (Object[])new Object[]{ClientAttachmentItemTooltip.rgbToHex(color)}).withStyle(Style.EMPTY.withColor(color)));
                    } else if (attachmentIndex.getLaserConfig() != null) {
                        int color = attachmentIndex.getLaserConfig().getDefaultColor();
                        this.components.add((Component)Component.translatable((String)"tooltip.tacz.attachment.laser.color", (Object[])new Object[]{ClientAttachmentItemTooltip.rgbToHex(color)}).withStyle(Style.EMPTY.withColor(color)));
                    }
                });
            }
            if (type == AttachmentType.SCOPE && (zoom = index.getZoom()) != null) {
                Object[] zoomText = new String[zoom.length];
                for (int i = 0; i < zoom.length; ++i) {
                    zoomText[i] = "x" + zoom[i];
                }
                String zoomJoinText = StringUtils.join((Object[])zoomText, (String)", ");
                this.components.add((Component)Component.translatable((String)"tooltip.tacz.attachment.zoom", (Object[])new Object[]{zoomJoinText}).withStyle(ChatFormatting.GOLD));
            }
            if (type == AttachmentType.EXTENDED_MAG) {
                int magLevel = data.getExtendedMagLevel();
                if (magLevel == 1) {
                    this.components.add((Component)Component.translatable((String)"tooltip.tacz.attachment.extended_mag_level_1").withStyle(ChatFormatting.GRAY));
                } else if (magLevel == 2) {
                    this.components.add((Component)Component.translatable((String)"tooltip.tacz.attachment.extended_mag_level_2").withStyle(ChatFormatting.BLUE));
                } else if (magLevel == 3) {
                    this.components.add((Component)Component.translatable((String)"tooltip.tacz.attachment.extended_mag_level_3").withStyle(ChatFormatting.LIGHT_PURPLE));
                }
            }
            data.getModifier().forEach((key, value) -> {
                List<Component> result = value.getComponents();
                this.components.addAll(result);
            });
        });
    }
}

