/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.resource.CommonAssetsManager;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.SimplePreparableReloadListener;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.profiling.ProfilerFiller;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class PackInfoManager
extends SimplePreparableReloadListener<Map<String, PackInfo>> {
    private static final Marker MARKER = MarkerManager.getMarker((String)"PackInfoLoader");
    private static final String PACK_INFO_NAME = "gunpack_info.json";
    private final Map<String, PackInfo> dataMap = Maps.newHashMap();

    protected Map<String, PackInfo> prepare(ResourceManager manager, ProfilerFiller pProfiler) {
        HashMap output = Maps.newHashMap();
        for (String namespaces : manager.getNamespaces()) {
            manager.getResource(ResourceLocation.fromNamespaceAndPath((String)namespaces, (String)PACK_INFO_NAME)).ifPresent(rl -> {
                try (BufferedReader reader = rl.openAsReader();){
                    PackInfo packInfo = (PackInfo)GsonHelper.fromJson((Gson)CommonAssetsManager.GSON, (Reader)reader, PackInfo.class, (boolean)true);
                    PackInfo packInfo1 = output.put(namespaces, packInfo);
                    if (packInfo1 != null) {
                        throw new IllegalStateException("Duplicate data file ignored with namespace " + namespaces);
                    }
                }
                catch (JsonParseException | IOException | IllegalArgumentException jsonparseexception) {
                    GunMod.LOGGER.error(MARKER, "Couldn't parse pack info for namespace '{}' from {}", (Object)namespaces, rl, (Object)jsonparseexception);
                }
            });
        }
        return output;
    }

    protected void apply(Map<String, PackInfo> pObject, ResourceManager pResourceManager, ProfilerFiller pProfiler) {
        this.dataMap.clear();
        this.dataMap.putAll(pObject);
    }

    public PackInfo getData(String namespace) {
        return this.dataMap.get(namespace);
    }
}

