/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.other;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.tacz.guns.compat.iris.IrisCompat;
import javax.annotation.Nullable;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.util.Mth;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class HandRenderer {
    public static final HandRenderer INSTANCE = new HandRenderer();
    public static final float DEPTH = 0.125f;

    private PoseStack setupGlState(GameRenderer gameRenderer, Camera camera, float tickDelta) {
        PoseStack poseStack = new PoseStack();
        Matrix4f scaleMatrix = new Matrix4f().scale(1.0f, 1.0f, 0.125f);
        scaleMatrix.mul((Matrix4fc)gameRenderer.getProjectionMatrix(gameRenderer.getFov(camera, tickDelta, false)));
        gameRenderer.resetProjectionMatrix(scaleMatrix);
        poseStack.setIdentity();
        gameRenderer.bobHurt(poseStack, tickDelta);
        if (((Boolean)Minecraft.getInstance().options.bobView().get()).booleanValue()) {
            gameRenderer.bobView(poseStack, tickDelta);
        }
        return poseStack;
    }

    public void renderSolid(Renderer renderer, float tickDelta, Camera camera, GameRenderer gameRenderer) {
        if (IrisCompat.isUsingRenderPack()) {
            renderer.render(null);
            return;
        }
        Matrix4f projection = RenderSystem.getProjectionMatrix();
        PoseStack poseStack = this.setupGlState(gameRenderer, camera, tickDelta);
        poseStack.pushPose();
        RenderSystem.getModelViewStack().pushMatrix();
        RenderSystem.getModelViewStack().set((Matrix4fc)poseStack.last().pose());
        RenderSystem.applyModelViewMatrix();
        LocalPlayer playerEntity = Minecraft.getInstance().player;
        float f2 = Mth.lerp((float)tickDelta, (float)playerEntity.xBobO, (float)playerEntity.xBob);
        float f3 = Mth.lerp((float)tickDelta, (float)playerEntity.yBobO, (float)playerEntity.yBob);
        poseStack.mulPose(Axis.XP.rotationDegrees((playerEntity.getViewXRot(tickDelta) - f2) * 0.1f));
        poseStack.mulPose(Axis.YP.rotationDegrees((playerEntity.getViewYRot(tickDelta) - f3) * 0.1f));
        renderer.render(poseStack);
        Minecraft.getInstance().getProfiler().pop();
        gameRenderer.resetProjectionMatrix(projection);
        poseStack.popPose();
        RenderSystem.getModelViewStack().popMatrix();
        RenderSystem.applyModelViewMatrix();
    }

    @FunctionalInterface
    public static interface Renderer {
        public void render(@Nullable PoseStack var1);
    }
}

