/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.renderer.item;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.client.model.BedrockAmmoModel;
import com.tacz.guns.client.model.SlotModel;
import com.tacz.guns.client.model.bedrock.BedrockPart;
import com.tacz.guns.client.resource.pojo.TransformScale;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import org.joml.Vector3f;

public class AmmoItemRenderer
extends BlockEntityWithoutLevelRenderer {
    private static final SlotModel SLOT_AMMO_MODEL = new SlotModel();

    public AmmoItemRenderer(BlockEntityRenderDispatcher pBlockEntityRenderDispatcher, EntityModelSet pEntityModelSet) {
        super(pBlockEntityRenderDispatcher, pEntityModelSet);
    }

    private static void applyPositioningNodeTransform(List<BedrockPart> nodePath, PoseStack poseStack, Vector3f scale) {
        if (nodePath == null) {
            return;
        }
        if (scale == null) {
            scale = new Vector3f(1.0f, 1.0f, 1.0f);
        }
        poseStack.translate(0.0, 1.5, 0.0);
        for (int i = nodePath.size() - 1; i >= 0; --i) {
            BedrockPart t = nodePath.get(i);
            poseStack.mulPose(Axis.XN.rotation(t.xRot));
            poseStack.mulPose(Axis.YN.rotation(t.yRot));
            poseStack.mulPose(Axis.ZN.rotation(t.zRot));
            if (t.getParent() != null) {
                poseStack.translate(-t.x * scale.x() / 16.0f, -t.y * scale.y() / 16.0f, -t.z * scale.z() / 16.0f);
                continue;
            }
            poseStack.translate(-t.x * scale.x() / 16.0f, (1.5f - t.y / 16.0f) * scale.y(), -t.z * scale.z() / 16.0f);
        }
        poseStack.translate(0.0, -1.5, 0.0);
    }

    public void renderByItem(@Nonnull ItemStack stack, @Nonnull ItemDisplayContext transformType, @Nonnull PoseStack poseStack, @Nonnull MultiBufferSource pBuffer, int pPackedLight, int pPackedOverlay) {
        Item item = stack.getItem();
        if (!(item instanceof IAmmo)) {
            return;
        }
        IAmmo iAmmo = (IAmmo)item;
        ResourceLocation ammoId = iAmmo.getAmmoId(stack);
        poseStack.pushPose();
        TimelessAPI.getClientAmmoIndex(ammoId).ifPresentOrElse(ammoIndex -> {
            BedrockAmmoModel ammoModel = ammoIndex.getAmmoModel();
            ResourceLocation modelTexture = ammoIndex.getModelTextureLocation();
            if (transformType == ItemDisplayContext.GUI || ammoModel == null || modelTexture == null) {
                poseStack.translate(0.5, 1.5, 0.5);
                poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
                VertexConsumer buffer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)ammoIndex.getSlotTextureLocation()));
                SLOT_AMMO_MODEL.renderToBuffer(poseStack, buffer, pPackedLight, pPackedOverlay);
                return;
            }
            poseStack.translate(0.5, 2.0, 0.5);
            poseStack.scale(-1.0f, -1.0f, 1.0f);
            this.applyPositioningTransform(transformType, ammoIndex.getTransform().getScale(), ammoModel, poseStack);
            this.applyScaleTransform(transformType, ammoIndex.getTransform().getScale(), poseStack);
            RenderType renderType = RenderType.entityCutout((ResourceLocation)modelTexture);
            ammoModel.render(poseStack, transformType, renderType, pPackedLight, pPackedOverlay);
        }, () -> {
            poseStack.translate(0.5, 1.5, 0.5);
            poseStack.mulPose(Axis.ZN.rotationDegrees(180.0f));
            VertexConsumer buffer = pBuffer.getBuffer(RenderType.entityTranslucent((ResourceLocation)MissingTextureAtlasSprite.getLocation()));
            SLOT_AMMO_MODEL.renderToBuffer(poseStack, buffer, pPackedLight, pPackedOverlay);
        });
        poseStack.popPose();
    }

    private void applyPositioningTransform(ItemDisplayContext transformType, TransformScale scale, BedrockAmmoModel model, PoseStack poseStack) {
        switch (transformType) {
            case FIXED: {
                AmmoItemRenderer.applyPositioningNodeTransform(model.getFixedOriginPath(), poseStack, scale.getFixed());
                break;
            }
            case GROUND: {
                AmmoItemRenderer.applyPositioningNodeTransform(model.getGroundOriginPath(), poseStack, scale.getGround());
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                AmmoItemRenderer.applyPositioningNodeTransform(model.getThirdPersonHandOriginPath(), poseStack, scale.getThirdPerson());
            }
        }
    }

    private void applyScaleTransform(ItemDisplayContext transformType, TransformScale scale, PoseStack poseStack) {
        if (scale == null) {
            return;
        }
        Vector3f vector3f = null;
        switch (transformType) {
            case FIXED: {
                vector3f = scale.getFixed();
                break;
            }
            case GROUND: {
                vector3f = scale.getGround();
                break;
            }
            case THIRD_PERSON_RIGHT_HAND: 
            case THIRD_PERSON_LEFT_HAND: {
                vector3f = scale.getThirdPerson();
            }
        }
        if (vector3f != null) {
            poseStack.translate(0.0, 1.5, 0.0);
            poseStack.scale(vector3f.x(), vector3f.y(), vector3f.z());
            poseStack.translate(0.0, -1.5, 0.0);
        }
    }
}

