/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import java.text.DecimalFormat;
import net.minecraft.SharedConstants;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.ModList;
import org.jetbrains.annotations.Nullable;

public class GunHudOverlay {
    private static final ResourceLocation SEMI = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/hud/fire_mode_semi.png");
    private static final ResourceLocation AUTO = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/hud/fire_mode_auto.png");
    private static final ResourceLocation BURST = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/hud/fire_mode_burst.png");
    private static final ResourceLocation HEATBAR = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/hud/heat_bar.png");
    private static final ResourceLocation HEATBASE = ResourceLocation.fromNamespaceAndPath((String)"tacz", (String)"textures/hud/heat_base.png");
    private static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("000%");
    private static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static long checkAmmoTimestamp = -1L;
    private static int cacheMaxAmmoCount = 0;
    private static int cacheInventoryAmmoCount = 0;
    private static final int MAX_AMMO_COUNT = 9999;

    public static void render(GuiGraphics graphics, float partialTick, int width, int height) {
        String inventoryAmmoCountText;
        boolean overheatLocked;
        if (!((Boolean)RenderConfig.GUN_HUD_ENABLE.get()).booleanValue()) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        ItemStack stack = player.getMainHandItem();
        Item item = stack.getItem();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        ResourceLocation gunId = iGun.getGunId(stack);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }
        boolean useInventoryAmmo = iGun.useInventoryAmmo(stack);
        boolean useDummyAmmo = iGun.useDummyAmmo(stack);
        boolean bl = overheatLocked = gunData.hasHeatData() && iGun.isOverheatLocked(stack);
        int ammoCount = useInventoryAmmo ? cacheInventoryAmmoCount + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0) : iGun.getCurrentAmmoCount(stack) + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0);
        int ammoCountColor = (double)(ammoCount = Math.min(ammoCount, 9999)) < (double)cacheMaxAmmoCount * 0.25 && ammoCount < 10 || overheatLocked ? 0xFF5555 : (useInventoryAmmo && useDummyAmmo ? 0x55FFFF : (useInventoryAmmo ? 0xFFFF55 : 0xFFFFFF));
        int inventoryAmmoCountColor = !useInventoryAmmo && useDummyAmmo ? 0x55FFFF : 0xAAAAAA;
        String currentAmmoCountText = display.getAmmoCountStyle() == AmmoCountStyle.PERCENT ? CURRENT_AMMO_FORMAT_PERCENT.format((float)ammoCount / (cacheMaxAmmoCount == 0 ? 1.0f : (float)cacheMaxAmmoCount)) : CURRENT_AMMO_FORMAT.format(ammoCount);
        String string = inventoryAmmoCountText = useInventoryAmmo ? "" : INVENTORY_AMMO_FORMAT.format(cacheInventoryAmmoCount);
        if (!useInventoryAmmo && gunData.getReloadData().isInfinite()) {
            inventoryAmmoCountText = "\u221e";
        }
        GunHudOverlay.handleCacheCount(player, stack, gunData, iGun, useInventoryAmmo);
        graphics.fill(width - 75, height - 43, width - 74, height - 25, -1);
        PoseStack poseStack = graphics.pose();
        Font font = mc.font;
        poseStack.pushPose();
        poseStack.scale(1.5f, 1.5f, 1.0f);
        graphics.drawString(font, currentAmmoCountText, (float)(width - 70) / 1.5f, (float)(height - 43) / 1.5f, ammoCountColor, false);
        poseStack.popPose();
        poseStack.pushPose();
        poseStack.scale(0.8f, 0.8f, 1.0f);
        graphics.drawString(font, inventoryAmmoCountText, ((float)(width - 68) + (float)mc.font.width(currentAmmoCountText) * 1.5f) / 0.8f, (float)(height - 43) / 0.8f, inventoryAmmoCountColor, false);
        poseStack.popPose();
        String minecraftVersion = SharedConstants.getCurrentVersion().getName();
        String modVersion = ModList.get().getModFileById("tacz").versionString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        poseStack.pushPose();
        poseStack.scale(0.5f, 0.5f, 1.0f);
        graphics.drawString(font, debugInfo, (int)((float)(width - 70) / 0.5f), (int)(((float)height - 29.0f) / 0.5f), -5592406);
        poseStack.popPose();
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        ResourceLocation hudTexture = display.getHUDTexture();
        @Nullable ResourceLocation hudEmptyTexture = display.getHudEmptyTexture();
        if (ammoCount <= 0 || overheatLocked) {
            if (hudEmptyTexture == null) {
                RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
            } else {
                hudTexture = hudEmptyTexture;
            }
        }
        graphics.blit(hudTexture, width - 117, height - 44, 0.0f, 0.0f, 39, 13, 39, 13);
        FireMode fireMode = IGun.getMainHandFireMode((LivingEntity)player);
        ResourceLocation fireModeTexture = switch (fireMode) {
            case FireMode.AUTO -> AUTO;
            case FireMode.BURST -> BURST;
            default -> SEMI;
        };
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        graphics.blit(fireModeTexture, (int)((double)width - 68.5 + (double)mc.font.width(currentAmmoCountText) * 1.5), height - 38, 0.0f, 0.0f, 10, 10, 10, 10);
    }

    private static void handleCacheCount(LocalPlayer player, ItemStack stack, GunData gunData, IGun iGun, boolean useInventoryAmmo) {
        if (System.currentTimeMillis() - checkAmmoTimestamp > 50L) {
            checkAmmoTimestamp = System.currentTimeMillis();
            cacheMaxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(stack, gunData);
            if (IGunOperator.fromLivingEntity((LivingEntity)player).needCheckAmmo()) {
                if (iGun.useDummyAmmo(stack)) {
                    cacheInventoryAmmoCount = iGun.getDummyAmmoAmount(stack);
                } else {
                    GunHudOverlay.handleInventoryAmmo(stack, player.getInventory());
                }
            } else {
                cacheInventoryAmmoCount = 9999;
            }
            if (useInventoryAmmo) {
                iGun.setCurrentAmmoCount(stack, cacheInventoryAmmoCount);
            }
        }
    }

    private static void handleInventoryAmmo(ItemStack stack, Inventory inventory) {
        cacheInventoryAmmoCount = 0;
        for (int i = 0; i < inventory.getContainerSize(); ++i) {
            IAmmoBox iAmmoBox;
            IAmmo iAmmo;
            ItemStack inventoryItem = inventory.getItem(i);
            Item item = inventoryItem.getItem();
            if (item instanceof IAmmo && (iAmmo = (IAmmo)item).isAmmoOfGun(stack, inventoryItem)) {
                cacheInventoryAmmoCount += inventoryItem.getCount();
            }
            if (!((item = inventoryItem.getItem()) instanceof IAmmoBox) || !(iAmmoBox = (IAmmoBox)item).isAmmoBoxOfGun(stack, inventoryItem)) continue;
            if (iAmmoBox.isAllTypeCreative(inventoryItem) || iAmmoBox.isCreative(inventoryItem)) {
                cacheInventoryAmmoCount = 9999;
                return;
            }
            cacheInventoryAmmoCount += iAmmoBox.getAmmoCount(inventoryItem);
        }
    }
}

