/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.network.message.ClientMessagePlayerCrawl;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.network.PacketDistributor;

public class LocalPlayerCrawl {
    private static final int COOLDOWN_TICKS = 10;
    private final LocalPlayer player;
    private boolean isCrawling = false;
    private int crawCooldownTicks = 0;

    public LocalPlayerCrawl(LocalPlayer player) {
        this.player = player;
    }

    public void crawl(boolean isCrawl) {
        ItemStack mainHandItem = this.player.getMainHandItem();
        Item item = mainHandItem.getItem();
        if (!(item instanceof IGun)) {
            return;
        }
        IGun iGun = (IGun)item;
        if (!iGun.isCanCrawl(mainHandItem)) {
            return;
        }
        if (this.crawCooldownTicks > 0) {
            return;
        }
        if (this.player.isSpectator() || this.player.isPassenger() || !this.player.onGround()) {
            return;
        }
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        TimelessAPI.getClientGunIndex(gunId).ifPresent(gunIndex -> {
            this.isCrawling = isCrawl;
            this.crawCooldownTicks = 10;
            PacketDistributor.sendToServer((CustomPacketPayload)new ClientMessagePlayerCrawl(isCrawl), (CustomPacketPayload[])new CustomPacketPayload[0]);
        });
    }

    public void tickCrawl() {
        ItemStack mainHandItem;
        Item item;
        if (this.crawCooldownTicks > 0) {
            --this.crawCooldownTicks;
        }
        if (!((item = (mainHandItem = this.player.getMainHandItem()).getItem()) instanceof IGun)) {
            this.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        IGun iGun = (IGun)item;
        if (!iGun.isCanCrawl(mainHandItem)) {
            this.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        ResourceLocation gunId = iGun.getGunId(mainHandItem);
        if (TimelessAPI.getCommonGunIndex(gunId).isEmpty()) {
            this.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        if (this.player.isSpectator() || this.player.isPassenger() || this.player.jumping || this.player.isSwimming() || !this.player.onGround()) {
            this.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        this.setCrawlPose();
    }

    public boolean isCrawling() {
        return this.isCrawling;
    }

    private void setCrawlPose() {
        if (this.isCrawling) {
            this.player.setForcedPose(Pose.SWIMMING);
        } else {
            this.player.setForcedPose(null);
        }
    }
}

