/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.animation.screen;

import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.gui.GunRefitScreen;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderFrameEvent;

@EventBusSubscriber(value={Dist.CLIENT}, modid="tacz")
public class RefitTransform {
    private static final float REFIT_SCREEN_TRANSFORM_TIMES = 0.25f;
    private static float refitScreenTransformProgress = 1.0f;
    private static long refitScreenTransformTimestamp = -1L;
    private static AttachmentType oldTransformType = AttachmentType.NONE;
    private static AttachmentType currentTransformType = AttachmentType.NONE;
    private static float refitScreenOpeningProgress = 0.0f;
    private static long refitScreenOpeningTimestamp = -1L;

    public static void init() {
        refitScreenTransformProgress = 1.0f;
        refitScreenTransformTimestamp = System.currentTimeMillis();
        oldTransformType = AttachmentType.NONE;
        currentTransformType = AttachmentType.NONE;
    }

    public static float getOpeningProgress() {
        return refitScreenOpeningProgress;
    }

    @Nonnull
    public static AttachmentType getOldTransformType() {
        return Objects.requireNonNullElse(oldTransformType, AttachmentType.NONE);
    }

    @Nonnull
    public static AttachmentType getCurrentTransformType() {
        return Objects.requireNonNullElse(currentTransformType, AttachmentType.NONE);
    }

    public static float getTransformProgress() {
        return refitScreenTransformProgress;
    }

    public static boolean changeRefitScreenView(AttachmentType attachmentType) {
        if (refitScreenTransformProgress != 1.0f || refitScreenOpeningProgress != 1.0f) {
            return false;
        }
        oldTransformType = currentTransformType;
        currentTransformType = attachmentType;
        refitScreenTransformProgress = 0.0f;
        refitScreenTransformTimestamp = System.currentTimeMillis();
        return true;
    }

    @SubscribeEvent
    public static void tickInterpolation(RenderFrameEvent.Pre event) {
        if (refitScreenOpeningTimestamp == -1L) {
            refitScreenOpeningTimestamp = System.currentTimeMillis();
        }
        if (Minecraft.getInstance().screen instanceof GunRefitScreen) {
            if ((refitScreenOpeningProgress += (float)(System.currentTimeMillis() - refitScreenOpeningTimestamp) / 250.0f) > 1.0f) {
                refitScreenOpeningProgress = 1.0f;
            }
        } else if ((refitScreenOpeningProgress -= (float)(System.currentTimeMillis() - refitScreenOpeningTimestamp) / 250.0f) < 0.0f) {
            refitScreenOpeningProgress = 0.0f;
        }
        refitScreenOpeningTimestamp = System.currentTimeMillis();
        if (refitScreenTransformTimestamp == -1L) {
            refitScreenTransformTimestamp = System.currentTimeMillis();
        }
        if ((refitScreenTransformProgress += (float)(System.currentTimeMillis() - refitScreenTransformTimestamp) / 250.0f) > 1.0f) {
            refitScreenTransformProgress = 1.0f;
        }
        refitScreenTransformTimestamp = System.currentTimeMillis();
    }
}

