/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block;

import com.mojang.authlib.properties.PropertyMap;
import com.mojang.serialization.MapCodec;
import com.tacz.guns.block.entity.TargetBlockEntity;
import com.tacz.guns.entity.EntityKineticBullet;
import com.tacz.guns.init.ModBlocks;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ResolvableProfile;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class TargetBlock
extends BaseEntityBlock {
    public static final MapCodec<TargetBlock> CODEC = TargetBlock.simpleCodec(properties -> new TargetBlock());
    public static final IntegerProperty OUTPUT_POWER = BlockStateProperties.POWER;
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty STAND = BooleanProperty.create((String)"stand");
    public static final VoxelShape BOX_BOTTOM_STAND_X = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.box((double)6.0, (double)13.0, (double)2.0, (double)10.0, (double)16.0, (double)14.0));
    public static final VoxelShape BOX_BOTTOM_STAND_Z = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0), (VoxelShape)Block.box((double)2.0, (double)13.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0));
    public static final VoxelShape BOX_BOTTOM_DOWN = Block.box((double)6.0, (double)0.0, (double)6.0, (double)10.0, (double)4.0, (double)10.0);
    public static final VoxelShape BOX_UPPER_X = Block.box((double)6.0, (double)0.0, (double)2.0, (double)10.0, (double)16.0, (double)14.0);
    public static final VoxelShape BOX_UPPER_Z = Block.box((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)16.0, (double)10.0);

    public TargetBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.0f, 3.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)STAND, (Comparable)Boolean.valueOf(true))).setValue((Property)OUTPUT_POWER, (Comparable)Integer.valueOf(0)));
    }

    protected MapCodec<TargetBlock> codec() {
        return CODEC;
    }

    public static int getRedstoneStrength(BlockHitResult hit, boolean isUpperBlock) {
        if (!isUpperBlock) {
            return 1;
        }
        Vec3 hitLocation = hit.getLocation();
        Direction direction = hit.getDirection();
        double x = Math.abs(Mth.frac((double)hitLocation.x) - 0.5);
        double y = Math.abs(Mth.frac((double)hitLocation.y) - 0.32);
        double z = Math.abs(Mth.frac((double)hitLocation.z) - 0.5);
        Direction.Axis axis = direction.getAxis();
        double distance = axis == Direction.Axis.Y ? Math.max(x, z) : (axis == Direction.Axis.Z ? Math.max(x, y) : Math.max(y, z));
        double percent = Mth.clamp((double)((0.25 - distance) / 0.25), (double)0.0, (double)1.0);
        return Math.max(1, Mth.ceil((double)(15.0 * percent)));
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return ((DoubleBlockHalf)state.getValue(HALF)).equals((Object)DoubleBlockHalf.LOWER) && level.isClientSide() ? TargetBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModBlocks.TARGET_BE.get()), TargetBlockEntity::clientTick) : null;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, HALF, STAND, OUTPUT_POWER});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        if (((DoubleBlockHalf)blockState.getValue(HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
            return new TargetBlockEntity(pos, blockState);
        }
        return null;
    }

    public VoxelShape getShape(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        boolean stand = (Boolean)state.getValue((Property)STAND);
        boolean axis = ((Direction)state.getValue((Property)FACING)).getAxis().equals((Object)Direction.Axis.X);
        if (((DoubleBlockHalf)state.getValue(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
            return stand ? (axis ? BOX_UPPER_X : BOX_UPPER_Z) : Shapes.empty();
        }
        return stand ? (axis ? BOX_BOTTOM_STAND_X : BOX_BOTTOM_STAND_Z) : BOX_BOTTOM_DOWN;
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        if (!((Boolean)state.getValue((Property)STAND)).booleanValue()) {
            level.setBlock(pos, (BlockState)((BlockState)state.setValue((Property)STAND, (Comparable)Boolean.valueOf(true))).setValue((Property)OUTPUT_POWER, (Comparable)Integer.valueOf(0)), 3);
        }
    }

    public void onProjectileHit(Level world, BlockState state, BlockHitResult hit, Projectile projectile) {
        if (hit.getDirection().getOpposite().equals((Object)state.getValue((Property)FACING))) {
            Entity entity;
            if (((DoubleBlockHalf)state.getValue(HALF)).equals((Object)DoubleBlockHalf.LOWER)) {
                world.getBlockEntity(hit.getBlockPos(), TargetBlockEntity.TYPE).ifPresent(e -> e.hit(world, state, hit, false));
            } else if (((DoubleBlockHalf)state.getValue(HALF)).equals((Object)DoubleBlockHalf.UPPER)) {
                world.getBlockEntity(hit.getBlockPos().below(), TargetBlockEntity.TYPE).ifPresent(e -> e.hit(world, state, hit, true));
            }
            if (!world.isClientSide() && (entity = projectile.getOwner()) instanceof Player) {
                Player player = (Player)entity;
                if (((Boolean)state.getValue((Property)STAND)).booleanValue() && projectile instanceof EntityKineticBullet) {
                    EntityKineticBullet bullet = (EntityKineticBullet)projectile;
                    String formattedDamage = String.format("%.1f", Float.valueOf(bullet.getDamage(hit.getLocation())));
                    String formattedDistance = String.format("%.2f", hit.getLocation().distanceTo(player.position()));
                    player.displayClientMessage((Component)Component.translatable((String)"message.tacz.target_minecart.hit", (Object[])new Object[]{formattedDamage, formattedDistance}), true);
                }
            }
        }
    }

    public BlockState updateShape(BlockState state, Direction facing, BlockState facingState, LevelAccessor level, BlockPos currentPos, BlockPos facingPos) {
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        boolean stand = (Boolean)state.getValue((Property)STAND);
        if (facing.getAxis() == Direction.Axis.Y && (half.equals((Object)DoubleBlockHalf.LOWER) && facing == Direction.UP || half.equals((Object)DoubleBlockHalf.UPPER) && facing == Direction.DOWN)) {
            if (!facingState.is((Block)this)) {
                return Blocks.AIR.defaultBlockState();
            }
            if ((Boolean)facingState.getValue((Property)STAND) != stand) {
                return (BlockState)((BlockState)state.setValue((Property)STAND, (Comparable)((Boolean)facingState.getValue((Property)STAND)))).setValue((Property)OUTPUT_POWER, (Comparable)((Integer)facingState.getValue((Property)OUTPUT_POWER)));
            }
        }
        if (half == DoubleBlockHalf.LOWER && facing == Direction.DOWN && !state.canSurvive((LevelReader)level, currentPos)) {
            return Blocks.AIR.defaultBlockState();
        }
        return state;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction direction = context.getHorizontalDirection();
        BlockPos clickedPos = context.getClickedPos();
        BlockPos above = clickedPos.above();
        Level level = context.getLevel();
        if (level.getBlockState(above).canBeReplaced(context) && level.getWorldBorder().isWithinBounds(above)) {
            return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)direction);
        }
        return null;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide) {
            BlockEntity blockentity;
            BlockPos above = pos.above();
            world.setBlock(above, (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER), 3);
            world.blockUpdated(pos, Blocks.AIR);
            state.updateNeighbourShapes((LevelAccessor)world, pos, 3);
            if (stack.has(DataComponents.CUSTOM_NAME) && (blockentity = world.getBlockEntity(pos)) instanceof TargetBlockEntity) {
                TargetBlockEntity e = (TargetBlockEntity)blockentity;
                e.setOwner(new ResolvableProfile(Optional.of(stack.getHoverName().getString()), Optional.empty(), new PropertyMap()));
                e.setCustomName(stack.getHoverName());
                e.refresh();
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockPos blockPos = state.getValue(HALF) == DoubleBlockHalf.LOWER ? pos : pos.below();
        BlockEntity blockentity = level.getBlockEntity(blockPos);
        if (blockentity instanceof TargetBlockEntity) {
            TargetBlockEntity e = (TargetBlockEntity)blockentity;
            ItemStack stack = new ItemStack((ItemLike)this);
            stack.set(DataComponents.CUSTOM_NAME, (Object)e.getCustomName());
            return stack;
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public boolean canSurvive(BlockState state, LevelReader level, BlockPos pos) {
        BlockPos blockpos = pos.below();
        BlockState blockstate = level.getBlockState(blockpos);
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return true;
        }
        return blockstate.is((Block)this);
    }

    public boolean isSignalSource(BlockState state) {
        return true;
    }

    public int getSignal(BlockState blockState, BlockGetter blockAccess, BlockPos pos, Direction side) {
        return (Integer)blockState.getValue((Property)OUTPUT_POWER);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!(level.isClientSide() || state.is(oldState.getBlock()) || (Integer)state.getValue((Property)OUTPUT_POWER) <= 0 || level.getBlockTicks().hasScheduledTick(pos, (Object)this))) {
            level.setBlock(pos, (BlockState)state.setValue((Property)OUTPUT_POWER, (Comparable)Integer.valueOf(0)), 18);
        }
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }
}

