/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.block;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.builder.BlockItemBuilder;
import com.tacz.guns.api.item.nbt.BlockItemDataAccessor;
import com.tacz.guns.block.entity.GunSmithTableBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGunSmithTableBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.HORIZONTAL_FACING;

    public AbstractGunSmithTableBlock() {
        super(BlockBehaviour.Properties.of().sound(SoundType.WOOD).strength(2.0f, 3.0f).noOcclusion());
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(this.getRootPos(pos, pState));
        if (blockEntity instanceof GunSmithTableBlockEntity) {
            GunSmithTableBlockEntity gunSmithTable = (GunSmithTableBlockEntity)blockEntity;
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                serverPlayer.openMenu((MenuProvider)gunSmithTable, buf -> {
                    ResourceLocation rl = gunSmithTable.getId() == null ? DefaultAssets.DEFAULT_BLOCK_ID : gunSmithTable.getId();
                    buf.writeResourceLocation(rl);
                });
            }
        }
        return InteractionResult.CONSUME;
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState blockState) {
        return new GunSmithTableBlockEntity(pos, blockState);
    }

    public RenderShape getRenderShape(BlockState pState) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.DESTROY;
    }

    public void setPlacedBy(Level world, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        Item item;
        super.setPlacedBy(world, pos, state, placer, stack);
        if (!world.isClientSide && (item = stack.getItem()) instanceof BlockItemDataAccessor) {
            BlockItemDataAccessor accessor = (BlockItemDataAccessor)item;
            ResourceLocation id = accessor.getBlockId(stack);
            BlockEntity blockentity = world.getBlockEntity(pos);
            if (blockentity instanceof GunSmithTableBlockEntity) {
                GunSmithTableBlockEntity e = (GunSmithTableBlockEntity)blockentity;
                e.setId(id);
            }
        }
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, LevelReader level, BlockPos pos, Player player) {
        BlockPos blockPos = this.getRootPos(pos, state);
        BlockEntity blockentity = level.getBlockEntity(blockPos);
        if (blockentity instanceof GunSmithTableBlockEntity) {
            GunSmithTableBlockEntity e = (GunSmithTableBlockEntity)blockentity;
            if (e.getId() != null) {
                return BlockItemBuilder.create((ItemLike)this).setId(e.getId()).build();
            }
            return new ItemStack((ItemLike)this);
        }
        return super.getCloneItemStack(state, target, level, pos, player);
    }

    public abstract boolean isRoot(BlockState var1);

    public float parseRotation(Direction direction) {
        return 90.0f * (float)(3 - direction.get2DDataValue()) - 90.0f;
    }

    public abstract BlockPos getRootPos(BlockPos var1, BlockState var2);
}

