/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;

public interface AmmoItemDataAccessor
extends IAmmo {
    public static final String AMMO_ID_TAG = "AmmoId";

    @Override
    @Nonnull
    default public ResourceLocation getAmmoId(ItemStack ammo) {
        CompoundTag nbt = ((CustomData)ammo.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag();
        if (nbt.contains(AMMO_ID_TAG, 8)) {
            ResourceLocation gunId = ResourceLocation.tryParse((String)nbt.getString(AMMO_ID_TAG));
            return Objects.requireNonNullElse(gunId, DefaultAssets.EMPTY_AMMO_ID);
        }
        return DefaultAssets.EMPTY_AMMO_ID;
    }

    @Override
    default public void setAmmoId(ItemStack ammo, @Nullable ResourceLocation ammoId) {
        ammo.update(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY, data -> data.update(tag -> {
            if (ammoId != null) {
                tag.putString(AMMO_ID_TAG, ammoId.toString());
                if (ammo.getItem() instanceof IAmmo) {
                    int maxStackSize = TimelessAPI.getCommonAmmoIndex(ammoId).map(CommonAmmoIndex::getStackSize).orElse(1);
                    ammo.set(DataComponents.MAX_STACK_SIZE, (Object)maxStackSize);
                }
                return;
            }
            tag.putString(AMMO_ID_TAG, DefaultAssets.DEFAULT_AMMO_ID.toString());
        }));
    }

    @Override
    default public boolean isAmmoOfGun(ItemStack gun, ItemStack ammo) {
        Item item = gun.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            item = ammo.getItem();
            if (item instanceof IAmmo) {
                IAmmo iAmmo = (IAmmo)item;
                ResourceLocation gunId = iGun.getGunId(gun);
                ResourceLocation ammoId = iAmmo.getAmmoId(ammo);
                return TimelessAPI.getCommonGunIndex(gunId).map(gunIndex -> gunIndex.getGunData().getAmmoId().equals((Object)ammoId)).orElse(false);
            }
        }
        return false;
    }
}

