/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.item.builder;

import com.google.common.collect.Maps;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.api.item.gun.GunItemManager;
import com.tacz.guns.init.ModItems;
import java.util.EnumMap;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.registries.DeferredItem;

public final class GunItemBuilder {
    private int count = 1;
    private int ammoCount = 0;
    private boolean heatData = false;
    private ResourceLocation gunId;
    private FireMode fireMode = FireMode.UNKNOWN;
    private boolean bulletInBarrel = false;
    private EnumMap<AttachmentType, ResourceLocation> attachments = Maps.newEnumMap(AttachmentType.class);

    private GunItemBuilder() {
    }

    public static GunItemBuilder create() {
        return new GunItemBuilder();
    }

    public GunItemBuilder setCount(int count) {
        this.count = Math.max(count, 1);
        return this;
    }

    public GunItemBuilder setAmmoCount(int count) {
        this.ammoCount = Math.max(count, 0);
        return this;
    }

    public GunItemBuilder setId(ResourceLocation id) {
        this.gunId = id;
        return this;
    }

    public GunItemBuilder setFireMode(FireMode fireMode) {
        this.fireMode = fireMode;
        return this;
    }

    public GunItemBuilder setAmmoInBarrel(boolean ammoInBarrel) {
        this.bulletInBarrel = ammoInBarrel;
        return this;
    }

    public GunItemBuilder putAttachment(AttachmentType type, ResourceLocation attachmentId) {
        this.attachments.put(type, attachmentId);
        return this;
    }

    public GunItemBuilder putAllAttachment(EnumMap<AttachmentType, ResourceLocation> attachments) {
        this.attachments = attachments;
        return this;
    }

    public GunItemBuilder setHeatData(boolean heatData) {
        this.heatData = heatData;
        return this;
    }

    public ItemStack forceBuild(HolderLookup.Provider provider) {
        ItemStack gun = new ItemStack((ItemLike)ModItems.MODERN_KINETIC_GUN.get(), this.count);
        Item item = gun.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            iGun.setGunId(gun, this.gunId);
            iGun.setFireMode(gun, this.fireMode);
            iGun.setCurrentAmmoCount(gun, this.ammoCount);
            iGun.setBulletInBarrel(gun, this.bulletInBarrel);
            if (this.heatData) {
                iGun.setHeatAmount(gun, 0.0f);
            }
            this.attachments.forEach((type, id) -> {
                ItemStack attachmentStack = AttachmentItemBuilder.create().setId((ResourceLocation)id).build();
                iGun.installAttachment(provider, gun, attachmentStack);
            });
        }
        return gun;
    }

    public ItemStack build(HolderLookup.Provider provider) {
        String itemType = TimelessAPI.getCommonGunIndex(this.gunId).map(index -> index.getPojo().getItemType()).orElse(null);
        if (itemType == null) {
            return ItemStack.EMPTY;
        }
        DeferredItem<? extends AbstractGunItem> gunItemRegistryObject = GunItemManager.getGunItemRegistryObject(itemType);
        if (gunItemRegistryObject == null) {
            return ItemStack.EMPTY;
        }
        ItemStack gun = new ItemStack((ItemLike)gunItemRegistryObject.get(), this.count);
        Item item = gun.getItem();
        if (item instanceof IGun) {
            IGun iGun = (IGun)item;
            iGun.setGunId(gun, this.gunId);
            iGun.setFireMode(gun, this.fireMode);
            iGun.setCurrentAmmoCount(gun, this.ammoCount);
            iGun.setBulletInBarrel(gun, this.bulletInBarrel);
            this.attachments.forEach((type, id) -> {
                ItemStack attachmentStack = AttachmentItemBuilder.create().setId((ResourceLocation)id).build();
                iGun.installAttachment(provider, gun, attachmentStack);
            });
        }
        return gun;
    }
}

