/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.other;

import com.google.common.collect.Maps;
import com.tacz.guns.api.client.other.IThirdPersonAnimation;
import java.util.Map;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;

public final class ThirdPersonManager {
    private static final Map<String, IThirdPersonAnimation> CACHE = Maps.newHashMap();
    private static final String RESERVED_DEFAULT_NAME = "default";
    private static final IThirdPersonAnimation DEFAULT = new IThirdPersonAnimation(){

        @Override
        public void animateGunHold(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head) {
            rightArm.yRot = -0.3f + head.yRot;
            leftArm.yRot = 0.8f + head.yRot;
            rightArm.xRot = -1.4f + head.xRot;
            leftArm.xRot = -1.4f + head.xRot;
        }

        @Override
        public void animateGunAim(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, float aimProgress) {
            float lerp1 = Mth.lerp((float)aimProgress, (float)0.3f, (float)0.35f);
            float lerp2 = Mth.lerp((float)aimProgress, (float)1.4f, (float)1.6f);
            rightArm.yRot = -lerp1 + head.yRot;
            leftArm.yRot = 0.8f + head.yRot;
            rightArm.xRot = -lerp2 + head.xRot;
            leftArm.xRot = -lerp2 + head.xRot;
        }
    };
    private static final String MINI_GUN_NAME = "minigun";
    private static final IThirdPersonAnimation MINI_GUN = new IThirdPersonAnimation(){

        @Override
        public void animateGunHold(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head) {
            body.yRot = head.yRot + 0.8f;
            double cosTheta = Math.cos(-body.yRot);
            double sinTheta = Math.sin(-body.yRot);
            float x = rightArm.x;
            rightArm.x = (float)((double)x * cosTheta);
            rightArm.z = (float)((double)x * sinTheta);
            rightArm.yRot = -1.0f + body.yRot;
            rightArm.xRot = -0.1f + body.xRot;
            float x2 = leftArm.x;
            leftArm.x = (float)((double)x2 * cosTheta);
            leftArm.z = (float)((double)x2 * sinTheta);
            leftArm.yRot = -0.1f + body.yRot;
            leftArm.xRot = -1.0f + body.xRot;
        }

        @Override
        public void animateGunAim(LivingEntity entity, ModelPart rightArm, ModelPart leftArm, ModelPart body, ModelPart head, float aimProgress) {
            this.animateGunHold(entity, rightArm, leftArm, body, head);
        }
    };

    public static void registerDefault() {
        CACHE.put(RESERVED_DEFAULT_NAME, DEFAULT);
        CACHE.put(MINI_GUN_NAME, MINI_GUN);
    }

    public static void register(String name, IThirdPersonAnimation animation) {
        if (name.equals(RESERVED_DEFAULT_NAME)) {
            return;
        }
        CACHE.put(name, animation);
    }

    public static IThirdPersonAnimation getAnimation(String name) {
        return CACHE.getOrDefault(name, DEFAULT);
    }
}

